/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSilentData;
import org.spongepowered.api.data.manipulator.mutable.entity.SilentData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSilentData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SilentDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Boolean, Value<Boolean>, SilentData, ImmutableSilentData> {
    public SilentDataProcessor() {
        super(Entity.class, Keys.IS_SILENT);
    }

    @Override
    protected SilentData createManipulator() {
        return new SpongeSilentData(false);
    }

    @Override
    protected boolean set(Entity entity, Boolean value) {
        entity.func_174810_b(value.booleanValue());
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(Entity entity) {
        return Optional.of(entity.func_174814_R());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_SILENT, false, value);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.IS_SILENT, false, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

