/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.flowpowered.math.vector.Vector3d;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.packet.SPacketWorldBorderBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.management.PlayerListBridge;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.player.PlayerPhase;
import org.spongepowered.common.service.ban.SpongeIPBanList;
import org.spongepowered.common.service.ban.SpongeUserListBans;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.whitelist.SpongeUserListWhitelist;
import org.spongepowered.common.text.chat.ChatUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@NonnullByDefault
@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger field_148546_d;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    @Final
    private Map<UUID, EntityPlayerMP> field_177454_f;
    @Shadow
    @Final
    private List<EntityPlayerMP> field_72404_b;
    @Shadow
    @Final
    private Map<UUID, PlayerAdvancements> field_192055_p;
    @Shadow
    private IPlayerFileData field_72412_k;

    @Shadow
    public abstract NBTTagCompound func_72380_a(EntityPlayerMP var1);

    @Shadow
    public abstract MinecraftServer func_72365_p();

    @Shadow
    public abstract int func_72352_l();

    @Shadow
    public abstract void func_148540_a(Packet<?> var1);

    @Shadow
    public abstract void func_72375_a(EntityPlayerMP var1, @Nullable WorldServer var2);

    @Shadow
    public abstract void func_72377_c(EntityPlayerMP var1);

    @Shadow
    public abstract void func_72354_b(EntityPlayerMP var1, WorldServer var2);

    @Shadow
    public abstract void func_187243_f(EntityPlayerMP var1);

    @Shadow
    public abstract void func_72385_f(EntityPlayerMP var1);

    @Nullable
    @Shadow
    public abstract String func_148542_a(SocketAddress var1, GameProfile var2);

    @Shadow
    private void func_72381_a(EntityPlayerMP playerIn, @Nullable EntityPlayerMP other, net.minecraft.world.World worldIn) {
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListBans"}))
    private UserListBans createBanList(File file) {
        return new SpongeUserListBans(file);
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListIPBans"}))
    private UserListIPBans createIPBanList(File file) {
        return new SpongeIPBanList(file);
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", args={"class=net/minecraft/server/management/UserListWhitelist"}))
    private UserListWhitelist createWhitelist(File file) {
        return new SpongeUserListWhitelist(file);
    }

    @Overwrite
    public EntityPlayerMP func_72368_a(EntityPlayerMP playerIn, int targetDimension, boolean conqueredEnd) {
        BlockPos bedPos;
        Location<World> toLocation;
        if (!conqueredEnd && targetDimension == 0) {
            targetDimension = playerIn.field_71093_bK;
        }
        if (playerIn.func_184207_aI()) {
            playerIn.func_184226_ay();
        }
        if (playerIn.func_184218_aH()) {
            playerIn.func_184210_p();
        }
        Player player = (Player)playerIn;
        Transform<World> fromTransform = player.getTransform();
        WorldServer toWorld = this.field_72400_f.func_71218_a(targetDimension);
        Location<World> temp = ((World)playerIn.field_70170_p).getSpawnLocation();
        boolean tempIsBedSpawn = false;
        if (toWorld == null) {
            toLocation = temp;
        } else {
            Dimension toDimension = (Dimension)toWorld.field_73011_w;
            int toDimensionId = ((WorldServerBridge)toWorld).bridge$getDimensionId();
            if (!toDimension.allowsPlayerRespawns()) {
                toDimensionId = SpongeImplHooks.getRespawnDimension((WorldProvider)toDimension, playerIn);
                toWorld = toWorld.func_73046_m().func_71218_a(toDimensionId);
            }
            Vector3d targetSpawnVec = VecHelper.toVector3d(SpongeImplHooks.getRandomizedSpawnPoint(toWorld));
            bedPos = SpongeImplHooks.getBedLocation((EntityPlayer)playerIn, toDimensionId);
            if (bedPos != null) {
                boolean forceBedSpawn = SpongeImplHooks.isSpawnForced((EntityPlayer)playerIn, toDimensionId);
                BlockPos bedSpawnLoc = EntityPlayer.func_180467_a((net.minecraft.world.World)toWorld, (BlockPos)bedPos, (boolean)forceBedSpawn);
                if (bedSpawnLoc != null) {
                    tempIsBedSpawn = true;
                    targetSpawnVec = new Vector3d((double)bedSpawnLoc.func_177958_n() + 0.5, (double)bedSpawnLoc.func_177956_o() + 0.1, (double)bedSpawnLoc.func_177952_p() + 0.5);
                } else {
                    playerIn.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(0, 0.0f));
                }
            }
            toLocation = new Location<World>((World)toWorld, targetSpawnVec);
        }
        Transform<World> toTransform = new Transform<World>(toLocation, Vector3d.ZERO, Vector3d.ZERO);
        targetDimension = ((WorldServerBridge)((Object)toTransform.getExtent())).bridge$getDimensionId();
        Location<World> location = toTransform.getLocation();
        if (conqueredEnd) {
            MoveEntityEvent.Teleport teleportEvent = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)playerIn, location);
            if (teleportEvent.isCancelled()) {
                playerIn.field_71136_j = false;
                return playerIn;
            }
            toTransform = teleportEvent.getToTransform();
            location = toTransform.getLocation();
        }
        Vector3d tempPos = player.getLocation().getPosition();
        playerIn.func_70107_b(location.getX(), location.getY(), location.getZ());
        while (!((WorldServer)location.getExtent()).func_184144_a((net.minecraft.entity.Entity)playerIn, playerIn.func_174813_aQ()).isEmpty() && location.getPosition().getY() < 256.0) {
            playerIn.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u + 1.0, playerIn.field_70161_v);
            location = location.add(0.0, 1.0, 0.0);
        }
        playerIn.func_70107_b(tempPos.getX(), tempPos.getY(), tempPos.getZ());
        playerIn.func_71121_q().func_73039_n().func_72787_a(playerIn);
        playerIn.func_71121_q().func_73039_n().func_72790_b((net.minecraft.entity.Entity)playerIn);
        playerIn.func_71121_q().func_184164_w().func_72695_c(playerIn);
        this.field_72404_b.remove(playerIn);
        this.field_72400_f.func_71218_a(playerIn.field_71093_bK).func_72973_f((net.minecraft.entity.Entity)playerIn);
        bedPos = SpongeImplHooks.getBedLocation((EntityPlayer)playerIn, targetDimension);
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager((net.minecraft.world.World)this.field_72400_f.func_71218_a(targetDimension)) : new PlayerInteractionManager((net.minecraft.world.World)this.field_72400_f.func_71218_a(targetDimension));
        playerIn.field_71093_bK = targetDimension;
        EntityPlayerMP newPlayer = new EntityPlayerMP(SpongeImpl.getServer(), toWorld, playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        newPlayer.field_71135_a = playerIn.field_71135_a;
        newPlayer.func_193104_a(playerIn, conqueredEnd);
        newPlayer.func_145769_d(playerIn.func_145782_y());
        newPlayer.func_174817_o((net.minecraft.entity.Entity)playerIn);
        newPlayer.func_184819_a(playerIn.func_184591_cq());
        if (bedPos != null && tempIsBedSpawn) {
            newPlayer.func_180473_a(bedPos, playerIn.func_82245_bX());
        }
        ((EntityPlayerMPBridge)newPlayer).bridge$setScoreboardOnRespawn(((Player)playerIn).getScoreboard());
        ((EntityPlayerMPBridge)playerIn).bridge$removeScoreboardOnRespawn();
        for (String s : playerIn.func_184216_O()) {
            newPlayer.func_184211_a(s);
        }
        ((EntityPlayerMPBridge)playerIn).bridge$setDelegateAfterRespawn(newPlayer);
        toTransform = toTransform.setLocation(location);
        Sponge.getCauseStackManager().pushCause(newPlayer);
        this.func_72381_a(newPlayer, playerIn, (net.minecraft.world.World)toWorld);
        RespawnPlayerEvent event = SpongeEventFactory.createRespawnPlayerEvent(Sponge.getCauseStackManager().getCurrentCause(), fromTransform, toTransform, (Player)playerIn, (Player)newPlayer, tempIsBedSpawn, !conqueredEnd);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        ((EntityBridge)((Object)player)).bridge$setLocationAndAngles(event.getToTransform());
        toTransform = event.getToTransform();
        location = toTransform.getLocation();
        if (!(location.getExtent() instanceof WorldServer)) {
            SpongeImpl.getLogger().warn("LocationBridge set in PlayerRespawnEvent was invalid, using original location instead");
            location = event.getFromTransform().getLocation();
        }
        toWorld = (WorldServer)location.getExtent();
        WorldServerBridge toWorldBridge = (WorldServerBridge)toWorld;
        newPlayer.field_71093_bK = toWorldBridge.bridge$getDimensionId();
        newPlayer.func_70029_a((net.minecraft.world.World)toWorld);
        newPlayer.field_71134_c.func_73080_a(toWorld);
        this.func_72381_a(newPlayer, playerIn, (net.minecraft.world.World)toWorld);
        toWorld.func_72863_F().func_186028_c((int)location.getX() >> 4, (int)location.getZ() >> 4);
        int dimensionId = WorldManager.getClientDimensionId(newPlayer, (net.minecraft.world.World)toWorld);
        if (((EntityPlayerMPBridge)newPlayer).bridge$usesCustomClient()) {
            WorldManager.sendDimensionRegistration(newPlayer, toWorld.field_73011_w);
        } else if (fromTransform.getExtent().getUniqueId() != ((World)toWorld).getUniqueId() && fromTransform.getExtent().getDimension().getType() == toTransform.getExtent().getDimension().getType()) {
            newPlayer.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId >= 0 ? -1 : 0, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), newPlayer.field_71134_c.func_73081_b()));
        }
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), newPlayer.field_71134_c.func_73081_b()));
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketServerDifficulty(toWorld.func_175659_aa(), toWorld.func_72912_H().func_176123_z()));
        newPlayer.field_71135_a.func_147364_a(location.getX(), location.getY(), location.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
        BlockPos spawnLocation = toWorld.func_175694_M();
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(spawnLocation));
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(newPlayer.field_71106_cc, newPlayer.field_71067_cb, newPlayer.field_71068_ca));
        this.func_72354_b(newPlayer, toWorld);
        this.func_187243_f(newPlayer);
        toWorld.func_184164_w().func_72683_a(newPlayer);
        Entity spongeEntity = (Entity)newPlayer;
        ((World)toWorld).spawnEntity(spongeEntity);
        this.field_72404_b.add(newPlayer);
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_GAME_MODE, new EntityPlayerMP[]{newPlayer}));
        for (DataManipulator<?, ?> container : ((CustomDataHolderBridge)playerIn).bridge$getCustomManipulators()) {
            ((Player)newPlayer).offer(container);
        }
        this.field_177454_f.put(newPlayer.func_110124_au(), newPlayer);
        newPlayer.func_71116_b();
        ((EntityPlayerMPBridge)newPlayer).bridge$refreshScaledHealth();
        newPlayer.field_71135_a.func_147359_a((Packet)new SPacketHeldItemChange(playerIn.field_71071_by.field_70461_c));
        SpongeCommonEventFactory.callPostPlayerRespawnEvent(newPlayer, conqueredEnd);
        return newPlayer;
    }

    @Overwrite
    public void func_82448_a(net.minecraft.entity.Entity entityIn, int lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn) {
        EntityUtil.transferEntityToWorld(entityIn, null, toWorldIn, (ForgeITeleporterBridge)toWorldIn.func_85176_s(), false);
    }

    @Overwrite
    public void func_187242_a(EntityPlayerMP player, int dimension) {
        WorldServer toWorld = this.field_72400_f.func_71218_a(dimension);
        EntityUtil.transferPlayerToWorld(player, null, toWorld, (ForgeITeleporterBridge)toWorld.func_85176_s());
    }

    @Inject(method={"setPlayerManager"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetPlayerManager(WorldServer[] worlds, CallbackInfo callbackInfo) {
        if (this.field_72412_k == null) {
            this.field_72412_k = worlds[0].func_72860_G().func_75756_e();
        }
        callbackInfo.cancel();
    }

    @Redirect(method={"updateTimeAndWeatherForPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getWorldBorder()Lnet/minecraft/world/border/WorldBorder;"))
    private WorldBorder onUpdateTimeGetWorldBorder(WorldServer worldServer, EntityPlayerMP entityPlayerMP, WorldServer worldServerIn) {
        return worldServerIn.func_175723_af();
    }

    @Redirect(method={"updateTimeAndWeatherForPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal=0))
    private void onWorldBorderInitializePacket(NetHandlerPlayServer invoker, Packet<?> packet, EntityPlayerMP playerMP, WorldServer worldServer) {
        if (worldServer.field_73011_w instanceof WorldProviderHell) {
            ((SPacketWorldBorderBridge)packet).bridge$changeCoordinatesForNether();
        }
        invoker.func_147359_a(packet);
    }

    @Inject(method={"playerLoggedOut(Lnet/minecraft/entity/player/EntityPlayerMP;)V"}, at={@At(value="HEAD")})
    private void onPlayerLogOut(EntityPlayerMP player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((Object)((Player)player).getScoreboard())).bridge$removePlayer(player, false);
    }

    @Redirect(method={"playerLoggedOut(Lnet/minecraft/entity/player/EntityPlayerMP;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;removeEntity(Lnet/minecraft/entity/Entity;)V"))
    private void onPlayerRemoveFromWorldFromDisconnect(WorldServer world, net.minecraft.entity.Entity player, EntityPlayerMP playerMP) {
        try (GeneralizedContext context = (GeneralizedContext)PlayerPhase.State.PLAYER_LOGOUT.createPhaseContext().source(playerMP);){
            context.buildAndSwitch();
            world.func_72900_e(player);
        }
    }

    @Inject(method={"saveAllPlayerData()V"}, at={@At(value="RETURN")})
    private void onSaveAllPlayerData(CallbackInfo ci) {
        for (SpongeUser user : SpongeUser.dirtyUsers) {
            user.save();
        }
    }

    @Inject(method={"playerLoggedIn"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void impl$sendAddPlayerListItemPacketAndPreparePlayer(EntityPlayerMP player, CallbackInfo ci) {
        SPacketPlayerListItem noSpecificViewerPacket = new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{player});
        for (EntityPlayerMP viewer : this.field_72404_b) {
            if (((Player)viewer).canSee((Player)player)) {
                viewer.field_71135_a.func_147359_a((Packet)noSpecificViewerPacket);
            }
            if (player != viewer && !((Player)player).canSee((Player)viewer)) continue;
            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{viewer}));
        }
        WorldServer level = this.field_72400_f.func_71218_a(player.field_71093_bK);
        level.func_72838_d((net.minecraft.entity.Entity)player);
        this.func_72375_a(player, null);
        ci.cancel();
    }

    @Inject(method={"writePlayerData"}, at={@At(target="Lnet/minecraft/world/storage/IPlayerFileData;writePlayerData(Lnet/minecraft/entity/player/EntityPlayer;)V", value="INVOKE")})
    private void impl$saveSpongePlayerDataAfterSavingPlayerData(EntityPlayerMP playerMP, CallbackInfo callbackInfo) {
        SpongePlayerDataHandler.savePlayer(playerMP.func_110124_au());
    }

    @ModifyVariable(method={"sendPlayerPermissionLevel"}, at=@At(value="HEAD"), argsOnly=true)
    private int impl$UpdatePermLevel(int permLevel) {
        if (!(Sponge.getServiceManager().provideUnchecked(PermissionService.class) instanceof SpongePermissionService)) {
            return 4;
        }
        return permLevel;
    }

    @Redirect(method={"updatePermissionLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getWorldInfo()Lnet/minecraft/world/storage/WorldInfo;"))
    private WorldInfo onGetWorldInfo(WorldServer overworld, EntityPlayerMP player) {
        return player.field_70170_p.func_72912_H();
    }

    @Overwrite
    public void func_148544_a(ITextComponent component, boolean isSystem) {
        ChatUtil.sendMessage(component, MessageChannel.TO_ALL, (CommandSource)this.field_72400_f, !isSystem);
    }

    @Override
    public void bridge$reloadAdvancementProgress() {
        for (PlayerAdvancements playerAdvancements : this.field_192055_p.values()) {
            ((PlayerAdvancementsBridge)playerAdvancements).bridge$reloadAdvancementProgress();
        }
    }
}

