/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.ChunkRegenerateFlags;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.world.SpongeChunkRegenerateFlag;

public final class ChunkRegenerateFlagRegistryModule
implements RegistryModule {
    @RegisterCatalog(value=ChunkRegenerateFlags.class)
    private final Map<String, SpongeChunkRegenerateFlag> flags = new LinkedHashMap<String, SpongeChunkRegenerateFlag>();
    private final Int2ObjectMap<SpongeChunkRegenerateFlag> maskedFlags = new Int2ObjectLinkedOpenHashMap(70);
    private static ChunkRegenerateFlagRegistryModule INSTANCE = new ChunkRegenerateFlagRegistryModule();

    public static ChunkRegenerateFlagRegistryModule getInstance() {
        return INSTANCE;
    }

    private ChunkRegenerateFlagRegistryModule() {
    }

    public static SpongeChunkRegenerateFlag fromNativeInt(int flag) {
        SpongeChunkRegenerateFlag spongeChunkRegenerateFlag = (SpongeChunkRegenerateFlag)ChunkRegenerateFlagRegistryModule.getInstance().maskedFlags.get(flag);
        if (spongeChunkRegenerateFlag != null) {
            return spongeChunkRegenerateFlag;
        }
        return (SpongeChunkRegenerateFlag)ChunkRegenerateFlags.ALL;
    }

    @Override
    public void registerDefaults() {
        this.register(new SpongeChunkRegenerateFlag("NONE".toLowerCase(Locale.ENGLISH), 0));
        this.register(new SpongeChunkRegenerateFlag("ALL".toLowerCase(Locale.ENGLISH), 3));
        this.register(new SpongeChunkRegenerateFlag("CREATE".toLowerCase(Locale.ENGLISH), 1));
        this.register(new SpongeChunkRegenerateFlag("ENTITIES".toLowerCase(Locale.ENGLISH), 2));
        RegistryHelper.mapFields(ChunkRegenerateFlags.class, this.flags);
    }

    private void register(SpongeChunkRegenerateFlag flag) {
        this.maskedFlags.put(flag.getRawFlag(), (Object)flag);
        this.flags.put(flag.getName(), flag);
    }

    public Collection<SpongeChunkRegenerateFlag> getValues() {
        return Collections.unmodifiableCollection(this.flags.values());
    }

    public static final class Flags {
        public static final int CREATE = 1;
        public static final int ENTITIES = 2;
        public static final int NONE = 0;
        public static final int ALL = 3;
    }
}

