/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;
import org.spongepowered.common.world.SpongePortalAgentType;

public class VirtualPortalAgent
implements PortalAgent {
    private static final Map<Class<? extends ForgeITeleporterBridge>, PortalAgentType> TYPES = new HashMap<Class<? extends ForgeITeleporterBridge>, PortalAgentType>();
    private final ForgeITeleporterBridge teleporter;
    private final PortalAgentType type;

    public static PortalAgent workaround(ForgeITeleporterBridge teleporter) {
        if (teleporter instanceof PortalAgent) {
            return (PortalAgent)((Object)teleporter);
        }
        return new VirtualPortalAgent(teleporter);
    }

    public VirtualPortalAgent(ForgeITeleporterBridge teleporter) {
        this.teleporter = teleporter;
        this.type = VirtualPortalAgent.getType(teleporter.getClass());
    }

    private static PortalAgentType getType(Class<? extends ForgeITeleporterBridge> teleporterClass) {
        return TYPES.computeIfAbsent(teleporterClass, klass -> {
            String modId = SpongeImplHooks.getModIdFromClass(teleporterClass);
            String name = teleporterClass.getSimpleName().toLowerCase(Locale.ENGLISH);
            return new SpongePortalAgentType(modId + ':' + name, name, teleporterClass);
        });
    }

    public ForgeITeleporterBridge getTeleporter() {
        return this.teleporter;
    }

    @Override
    public int getSearchRadius() {
        return 0;
    }

    @Override
    public PortalAgent setSearchRadius(int radius) {
        return this;
    }

    @Override
    public int getCreationRadius() {
        return 0;
    }

    @Override
    public PortalAgent setCreationRadius(int radius) {
        return this;
    }

    @Override
    public Optional<Location<World>> findOrCreatePortal(Location<World> targetLocation) {
        return Optional.empty();
    }

    @Override
    public Optional<Location<World>> findPortal(Location<World> targetLocation) {
        return Optional.empty();
    }

    @Override
    public Optional<Location<World>> createPortal(Location<World> targetLocation) {
        return Optional.empty();
    }

    @Override
    public PortalAgentType getType() {
        return this.type;
    }
}

