/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.core;

import com.gmail.trentech.pjc.Main;
import com.gmail.trentech.pjc.utils.InvalidItemTypeException;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.item.recipe.crafting.ShapedCraftingRecipe;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;

public class RecipeManager {
    public static void register(String pluginId, ConfigurationNode node, ItemStack result) {
        try {
            Sponge.getRegistry().getCraftingRecipeRegistry().register((Recipe)RecipeManager.getShapedRecipe(pluginId, node, result));
        }
        catch (InvalidItemTypeException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack getItemStack(String item) throws InvalidItemTypeException {
        String[] args = item.split(":");
        Optional optionalItemType = Sponge.getRegistry().getType(ItemType.class, args[0] + ":" + args[1]);
        if (optionalItemType.isPresent()) {
            ItemStack itemStack = ItemStack.builder().itemType((ItemType)optionalItemType.get()).build();
            if (args.length == 3) {
                DataContainer container = itemStack.toContainer();
                DataQuery query = DataQuery.of((char)'/', (String)"UnsafeDamage");
                container.set(query, (Object)Integer.parseInt(args[2]));
                itemStack = (ItemStack)Sponge.getDataManager().deserialize(ItemStack.class, (DataView)container).get();
            }
            return itemStack;
        }
        throw new InvalidItemTypeException("ItemType in config.conf at " + item + " is invalid");
    }

    public static ItemType getItemType(String item) throws InvalidItemTypeException {
        String[] args = item.split(":");
        Optional optionalItemType = Sponge.getRegistry().getType(ItemType.class, args[0] + ":" + args[1]);
        if (optionalItemType.isPresent()) {
            return (ItemType)optionalItemType.get();
        }
        throw new InvalidItemTypeException("ItemType in config.conf at " + item + " is invalid");
    }

    public static ShapedCraftingRecipe getShapedRecipe(String pluginId, ConfigurationNode node, ItemStack result) throws InvalidItemTypeException {
        ShapedCraftingRecipe.Builder.RowsStep rows = ShapedCraftingRecipe.builder().rows();
        for (int i = 1; i < 4; ++i) {
            String[] row1 = node.getNode(new Object[]{"row" + i}).getString().split(",");
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i1 = 0; i1 < 3; ++i1) {
                String item = row1[i1];
                if (item.equalsIgnoreCase("NONE")) {
                    ingredients.add(Ingredient.builder().with((GameDictionary.Entry)ItemTypes.NONE).build());
                    continue;
                }
                if (item.split(":").length == 3) {
                    ItemStack itemStack = RecipeManager.getItemStack(item);
                    ingredients.add(Ingredient.builder().with(new ItemStack[]{itemStack}).withDisplay(new ItemStack[]{itemStack}).build());
                    continue;
                }
                ItemType itemType = RecipeManager.getItemType(item);
                ingredients.add(Ingredient.builder().with((GameDictionary.Entry)itemType).withDisplay(new ItemType[]{itemType}).build());
            }
            if (i == 3) {
                return rows.row(ingredients.toArray(new Ingredient[0])).result(result).build(pluginId + ":" + node.getNode(new Object[]{"id"}).getString(), (Object)Main.getPlugin());
            }
            rows.row(ingredients.toArray(new Ingredient[0]));
        }
        return null;
    }

    public static ShapelessCraftingRecipe getShapelessRecipe(String pluginId, ConfigurationNode node, ItemStack result) throws InvalidItemTypeException {
        try {
            ShapelessCraftingRecipe.Builder builder = ShapelessCraftingRecipe.builder();
            ShapelessCraftingRecipe.Builder.ResultStep resultStep = null;
            for (String item : node.getNode(new Object[]{"ingredients"}).getList(TypeToken.of(String.class))) {
                if (item.split(":").length == 3) {
                    ItemStack itemStack = RecipeManager.getItemStack(item);
                    resultStep = builder.addIngredient(Ingredient.builder().with(new ItemStack[]{itemStack}).withDisplay(new ItemStack[]{itemStack}).build());
                    continue;
                }
                ItemType itemType = RecipeManager.getItemType(item);
                resultStep = builder.addIngredient(Ingredient.builder().with((GameDictionary.Entry)itemType).withDisplay(new ItemType[]{itemType}).build());
            }
            return resultStep.result(result).build(pluginId + ":" + node.getNode(new Object[]{"id"}).getString(), (Object)Main.getPlugin());
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SmeltingRecipe getSmeltingRecipe(ConfigurationNode node, ItemStack result) throws InvalidItemTypeException {
        String item = node.getNode(new Object[]{"ingredient"}).getString();
        if (item.split(":").length == 3) {
            return SmeltingRecipe.builder().ingredient(RecipeManager.getItemStack(item)).result(result).build();
        }
        return SmeltingRecipe.builder().ingredient(RecipeManager.getItemType(item)).result(result).build();
    }
}

