/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.EnumHelper;

public class BodiesHelper {
    private static Map<CelestialBody, BodiesData> data = new HashMap<CelestialBody, BodiesData>();
    public static int max_tier = 6;
    public static int getDefaultDergrees = 20;

    public static Galaxies getGalaxy(String name) {
        for (Galaxies gal : Galaxies.values()) {
            if (!gal.getName().equals(name)) continue;
            return gal;
        }
        return null;
    }

    public static Map<CelestialBody, BodiesData> getData() {
        return data;
    }

    public static Galaxies registerGalaxy(String galaxy, String image) {
        return (Galaxies)EnumHelper.addEnum(Galaxies.class, (String)galaxy.toUpperCase(), (Class[])new Class[]{String.class}, (Object[])new Object[]{galaxy.toLowerCase()});
    }

    public static SolarSystem registerSolarSystem(String prefix, String name, String galaxy, Vector3 pos, String starname, float size) {
        SolarSystem body = new SolarSystem(name, galaxy);
        body.setMapPosition(pos);
        Star main = new Star(starname);
        main.setParentSolarSystem(body);
        main.setTierRequired(-1);
        main.setRelativeSize(size);
        main.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + name + "/" + starname + ".png"));
        body.setMainStar(main);
        return body;
    }

    public static Planet registerPlanet(SolarSystem system, String name, String prefix, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float size, float distancefromcenter, float relativetime, Biome ... biome) {
        Planet body = new Planet(name).setParentSolarSystem(system);
        String path = system.getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setRelativeOrbitTime(relativetime);
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/" + name + ".png"));
        if (provider != null) {
            body.setTierRequired(tier);
            body.setDimensionInfo(dimID, provider);
            if (biome != null) {
                body.setBiomeInfo(biome);
            }
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        return body;
    }

    public static Moon registerMoon(Planet parent, String name, String prefix, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float size, float distancefromcenter, float relativetime, Biome ... biome) {
        Moon body = new Moon(name).setParentPlanet(parent);
        String path = parent.getParentSolarSystem().getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setRelativeOrbitTime(relativetime);
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/moons/" + name + ".png"));
        if (provider != null) {
            body.setTierRequired(tier);
            body.setDimensionInfo(dimID, provider);
            if (biome != null) {
                body.setBiomeInfo(biome);
            }
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        return body;
    }

    public static Satellite registerSatellite(Planet parent, String prefix, Class<? extends WorldProvider> provider, int dimID, int dimIDStatic, float phase, float size, float distancefromcenter, float relativetime) {
        Satellite body = new Satellite("spacestation." + parent.getUnlocalizedName().replace("planet.", ""));
        body.setParentBody(parent);
        body.setRelativeOrbitTime(relativetime);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        if (provider != null) {
            body.setTierRequired(parent.getTierRequirement());
            body.setDimensionInfo(dimID, dimIDStatic, provider);
            body.setBiomeInfo(new Biome[]{ACBiome.ACSpace});
        }
        return body;
    }

    public static void registerBody(CelestialBody body, BodiesData bodydata, boolean registry) {
        if (registry) {
            if (body instanceof Planet) {
                GalaxyRegistry.registerPlanet((Planet)((Planet)body));
            }
            if (body instanceof Moon) {
                GalaxyRegistry.registerMoon((Moon)((Moon)body));
            }
        }
        BodiesHelper.registerBodyWithClass(body, bodydata);
    }

    public static void registerBodyWithClass(CelestialBody body, BodiesData bodydata) {
        data.put(body, bodydata);
    }

    public static float calculateGravity(float Si) {
        float i = (9.81f - Si) * 0.008664628f;
        float k = Math.round(i * 1000.0f);
        return k / 1000.0f;
    }

    public static String getBody(Object temp) {
        return GCCoreUtil.translate((String)("gui.info." + temp.toString().toLowerCase() + ".name"));
    }

    public static String classPlanet(CelestialBody body, WorldProvider dim) {
        BodiesData data = BodiesHelper.getData().get(body);
        if (body.getReachable() && body != GalacticraftCore.planetOverworld && dim instanceof IGalacticraftWorldProvider) {
            float temp = body.atmosphere.thermalLevel();
            boolean breath = body.atmosphere.isBreathable();
            String type = "";
            IAdvancedSpace.TempBody tempbody = IAdvancedSpace.TempBody.COMFORT;
            if (temp >= 2.0f) {
                tempbody = IAdvancedSpace.TempBody.HOT;
            }
            if (temp >= 1.0f && (double)temp < 2.0) {
                tempbody = IAdvancedSpace.TempBody.WARM;
            }
            if (temp > -1.0f && temp < 1.0f) {
                tempbody = IAdvancedSpace.TempBody.COMFORT;
            }
            if ((double)temp > -2.0 && temp <= -1.0f) {
                tempbody = IAdvancedSpace.TempBody.COOL;
            }
            if (temp <= -2.0f) {
                tempbody = IAdvancedSpace.TempBody.COLD;
            }
            type = BodiesHelper.getBody((Object)tempbody);
            if (!breath && body.atmosphere.hasNoGases()) {
                if ((double)((WorldProviderSpace)dim).getDayLength() == 0.0 || dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.ASTEROID) {
                    return BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.ASTEROID);
                }
                return type + " " + BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.SELENA);
            }
            if (breath) {
                return type + " " + BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.TERRA);
            }
            if (!breath && dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.TITAN) {
                type = temp > 2.5f ? BodiesHelper.getBody((Object)IAdvancedSpace.TempBody.HOT) : (temp < -2.5f ? BodiesHelper.getBody((Object)IAdvancedSpace.TempBody.ICY) : BodiesHelper.getBody((Object)IAdvancedSpace.TempBody.COMFORT));
                return type + " " + BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.TITAN);
            }
            if (dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.OCEANIDE) {
                return BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.OCEANIDE);
            }
            if (dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.GASGIANT) {
                return BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.GASGIANT);
            }
            if (temp < -3.0f) {
                return BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.ICEWORLD);
            }
            return type + " " + BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.DESERT);
        }
        if (body == GalacticraftCore.planetOverworld) {
            return BodiesHelper.getBody((Object)IAdvancedSpace.TempBody.COMFORT) + " " + BodiesHelper.getBody((Object)IAdvancedSpace.ClassBody.TERRA);
        }
        if (data != null && data.getClassPlanet() != null) {
            return BodiesHelper.getBody(data.getClassPlanet().name().toLowerCase());
        }
        return GCCoreUtil.translate((String)"gui.message.unknown");
    }

    public static enum Galaxies {
        MILKYWAY("milky_way", ""),
        ANDROMEDA("andromeda", "");

        private final String name;
        private final String image;

        private Galaxies(String name, String image) {
            this.name = name;
            this.image = image;
        }

        public String getName() {
            return this.name;
        }

        public String getImage() {
            return this.image;
        }
    }
}

