/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.core.Patch;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.NextTickListEntry;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public final class WorldServerPatch
extends Patch {
    @Override
    public boolean apply(ClassNode node) {
        InsnList instructions = WorldServerPatch.findInstructions(node, "<init>");
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!"newHashSet".equals(method.name)) continue;
            method.owner = WorldServerPatch.getName(WorldServerPatch.class) + "$NextTickListEntryHashSet";
            return true;
        }
        return false;
    }

    public static final class NextTickListEntryHashSet
    extends HashSet<NextTickListEntry> {
        private final transient Set<NextTickListEntryWrapper> backingSet = new HashSet<NextTickListEntryWrapper>();
        private final transient NextTickListEntryWrapper wrapper = new NextTickListEntryWrapper();

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public boolean contains(Object entry) {
            this.wrapper.entry = entry;
            return this.backingSet.contains(this.wrapper);
        }

        @Override
        public boolean add(NextTickListEntry entry) {
            return this.backingSet.add(new NextTickListEntryWrapper(entry));
        }

        @Override
        public boolean remove(Object entry) {
            this.wrapper.entry = entry;
            return this.backingSet.remove(this.wrapper);
        }

        public static HashSet newHashSet() {
            return new NextTickListEntryHashSet();
        }
    }

    public static final class NextTickListEntryWrapper {
        Object entry;

        public NextTickListEntryWrapper() {
        }

        public NextTickListEntryWrapper(Object entry) {
            this.entry = entry;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object entry) {
            return this.entry.equals(((NextTickListEntryWrapper)entry).entry);
        }
    }
}

