/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal.features;

import com.gmail.trentech.pjp.data.DataQueries;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.living.player.Player;

public class Command
implements DataSerializable {
    private String command;
    private SourceType srcType;

    public Command(SourceType srcType, String command) {
        this.srcType = srcType;
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public SourceType getSrcType() {
        return this.srcType;
    }

    public void execute() {
        Sponge.getGame().getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), this.command);
    }

    public void execute(Player player) {
        Sponge.getGame().getCommandManager().process((CommandSource)player, this.command);
    }

    public int getContentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(DataQueries.SRCTYPE, (Object)this.srcType.name()).set(DataQueries.COMMAND, (Object)this.command);
    }

    public static class Builder
    extends AbstractDataBuilder<Command> {
        public Builder() {
            super(Command.class, 0);
        }

        protected Optional<Command> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(DataQueries.SRCTYPE, new DataQuery[]{DataQueries.COMMAND})) {
                SourceType srcType = SourceType.valueOf((String)container.getString(DataQueries.SRCTYPE).get());
                String command = (String)container.getString(DataQueries.COMMAND).get();
                return Optional.of(new Command(srcType, command));
            }
            return Optional.empty();
        }
    }

    public static enum SourceType {
        PLAYER,
        CONSOLE;

    }
}

