/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.ChatEnum;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ChatCommand
extends AbstractCommand {
    public ChatCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalChatType = context.getOne("chat");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        if (!super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        if (optionalChatType.isPresent()) {
            this.setChatChannel(player, (ChatEnum)((Object)optionalChatType.get()));
        } else if (EagleFactionsPlugin.CHAT_LIST.containsKey(player.getUniqueId())) {
            if (EagleFactionsPlugin.CHAT_LIST.get(player.getUniqueId()).equals((Object)ChatEnum.ALLIANCE)) {
                this.setChatChannel(player, ChatEnum.FACTION);
            } else {
                this.setChatChannel(player, ChatEnum.GLOBAL);
            }
        } else {
            this.setChatChannel(player, ChatEnum.ALLIANCE);
        }
        return CommandResult.success();
    }

    private void setChatChannel(Player player, ChatEnum chatType) {
        switch (chatType) {
            case GLOBAL: {
                EagleFactionsPlugin.CHAT_LIST.remove(player.getUniqueId());
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.CHANGED_CHAT_TO, TextColors.GOLD, Messages.GLOBAL_CHAT, TextColors.RESET, "!"}));
                break;
            }
            case ALLIANCE: {
                EagleFactionsPlugin.CHAT_LIST.put(player.getUniqueId(), chatType);
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.CHANGED_CHAT_TO, TextColors.GOLD, Messages.ALLIANCE_CHAT, TextColors.RESET, "!"}));
                break;
            }
            case FACTION: {
                EagleFactionsPlugin.CHAT_LIST.put(player.getUniqueId(), chatType);
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.CHANGED_CHAT_TO, TextColors.GOLD, Messages.FACTION_CHAT, TextColors.RESET, "!"}));
            }
        }
    }
}

