/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.integrations.dynmap;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.DynmapService;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.util.DynmapUtils;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.util.TempAreaMarker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.World;

public class DynmapUpdateTask
implements Runnable {
    private ArrayList<Faction> drawnFactions = new ArrayList();
    private HashMap<String, Marker> drawnMarkers = new HashMap();
    private HashMap<String, ArrayList<AreaMarker>> drawnAreas = new HashMap();

    @Override
    public void run() {
        Iterator<Faction> iterator = this.drawnFactions.iterator();
        while (iterator.hasNext()) {
            Faction drawmFaction = iterator.next();
            Faction currentFaction = EagleFactionsPlugin.getPlugin().getFactionLogic().getFactionByName(drawmFaction.getName());
            if (currentFaction != null && currentFaction.equals(drawmFaction)) continue;
            if (this.drawnMarkers.get(drawmFaction.getName()) != null) {
                this.drawnMarkers.get(drawmFaction.getName()).deleteMarker();
                this.drawnMarkers.remove(drawmFaction.getName());
            }
            if (this.drawnAreas.get(drawmFaction.getName()) != null) {
                for (AreaMarker drawFactionArea : this.drawnAreas.get(drawmFaction.getName())) {
                    drawFactionArea.deleteMarker();
                }
                this.drawnAreas.remove(drawmFaction.getName());
            }
            iterator.remove();
        }
        for (Faction faction : new HashSet<Faction>(EagleFactionsPlugin.getPlugin().getFactionLogic().getFactions().values())) {
            if (faction.getClaims().size() < 1 || this.drawnFactions.contains(faction)) continue;
            if (faction.getHome() != null) {
                World factionHomeWorld;
                World world = factionHomeWorld = Sponge.getServer().getWorld(faction.getHome().getWorldUUID()).isPresent() ? (World)Sponge.getServer().getWorld(faction.getHome().getWorldUUID()).get() : null;
                if (factionHomeWorld != null) {
                    Vector3i blockPos = faction.getHome().getBlockPosition();
                    Marker marker = DynmapService.markerSet.createMarker(null, faction.getName() + " Home", factionHomeWorld.getName(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), DynmapService.markerapi.getMarkerIcon(EagleFactionsPlugin.getPlugin().getConfiguration().getDynmapConfig().getDynmapFactionHomeIcon()), false);
                    this.drawnMarkers.put(faction.getName(), marker);
                }
            }
            HashMap<UUID, Set> claimsWorld = new HashMap<UUID, Set>();
            Marker claims = new Claim[faction.getClaims().size()];
            for (Claim claim : claims = faction.getClaims().toArray((T[])claims)) {
                claimsWorld.computeIfAbsent(claim.getWorldUUID(), k -> new HashSet());
                ((Set)claimsWorld.get(claim.getWorldUUID())).add(claim);
            }
            HashMap areaMarkers = new HashMap();
            claimsWorld.forEach((k, v) -> {
                ArrayList<TempAreaMarker> tempMarkers = DynmapUtils.createAreas(v);
                areaMarkers.put(k, tempMarkers);
            });
            this.drawnAreas.put(faction.getName(), new ArrayList());
            for (Map.Entry entry : areaMarkers.entrySet()) {
                for (TempAreaMarker tempMarker : (ArrayList)entry.getValue()) {
                    World world;
                    World world2 = world = Sponge.getServer().getWorld((UUID)entry.getKey()).isPresent() ? (World)Sponge.getServer().getWorld((UUID)entry.getKey()).get() : null;
                    if (world == null) continue;
                    AreaMarker areaMarker = DynmapService.markerSet.createAreaMarker(null, faction.getName(), false, world.getName(), new double[1000], new double[1000], false);
                    areaMarker.setDescription(DynmapUtils.getFactionInfoWindow(faction));
                    int areaColor = DynmapUtils.getAreaColor(faction);
                    areaMarker.setLineStyle(3, 0.8, areaColor);
                    areaMarker.setFillStyle(0.35, areaColor);
                    areaMarker.setCornerLocations(tempMarker.x, tempMarker.z);
                    this.drawnAreas.get(faction.getName()).add(areaMarker);
                }
            }
            this.drawnFactions.add(faction);
        }
    }
}

