/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import io.github.nucleuspowered.nucleus.Nucleus;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;

public class GameProfileArgument
extends CommandElement {
    private final Pattern p = Pattern.compile("[a-zA-Z0-9_]{1,16}");

    public GameProfileArgument(@Nullable Text key) {
        super(key);
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String name = args.next();
        if (!this.p.matcher(name).matches()) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.gameprofile.format", new String[0]));
        }
        List lgp = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getAll().stream().filter(x -> x.getName().isPresent() && ((String)x.getName().get()).equalsIgnoreCase(name)).collect(Collectors.toList());
        if (lgp.isEmpty()) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.gameprofile.none", name));
        }
        if (lgp.size() == 1) {
            return lgp.get(0);
        }
        return lgp;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        try {
            String arg = args.peek().toLowerCase();
            List onlinePlayers = Sponge.getServer().getOnlinePlayers().stream().map(User::getName).collect(Collectors.toList());
            return ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getAll().stream().filter(x -> x.getName().isPresent() && ((String)x.getName().get()).toLowerCase().startsWith(arg)).map(x -> (String)x.getName().get()).sorted((first, second) -> {
                boolean secondBool;
                boolean firstBool = onlinePlayers.contains(first);
                if (firstBool == (secondBool = onlinePlayers.contains(second))) {
                    return first.compareTo((String)second);
                }
                return firstBool ? -1 : 1;
            }).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return new ArrayList<String>();
        }
    }
}

