/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.userprefs;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;

public class PreferenceKey<T>
implements NucleusUserPreferenceService.PreferenceKey<T> {
    private final String key;
    @Nullable
    private final T def;
    private final Class<T> clazz;
    private final Predicate<User> canAccess;
    private final String descriptionKey;

    PreferenceKey(String key, @Nullable T def, Class<T> clazz, String permission, String descriptionKey) {
        this(key, def, clazz, (User user) -> Nucleus.getNucleus().getPermissionResolver().hasPermission((Subject)user, permission), descriptionKey);
    }

    PreferenceKey(String key, @Nullable T def, Class<T> clazz, Predicate<User> canAccess, String descriptionKey) {
        this.key = key;
        this.def = def;
        this.clazz = clazz;
        this.canAccess = canAccess;
        this.descriptionKey = descriptionKey;
    }

    @Override
    public String getID() {
        return this.key;
    }

    @Override
    public Optional<T> getDefaultValue() {
        return Optional.ofNullable(this.def);
    }

    @Override
    public Class<T> getValueClass() {
        return this.clazz;
    }

    @Override
    public boolean canAccess(User user) {
        return this.canAccess.test(user);
    }

    @Override
    public String getDescription() {
        return Nucleus.getNucleus().getMessageProvider().getMessageWithFormat(this.descriptionKey, new String[0]);
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static class BooleanKey
    extends PreferenceKey<Boolean> {
        public BooleanKey(String key, @Nullable Boolean def, String permission, String descriptionKey) {
            super(key, def, Boolean.class, permission, descriptionKey);
        }

        public BooleanKey(String key, @Nullable Boolean def, Predicate<User> canAccess, String descriptionKey) {
            super(key, def, Boolean.class, canAccess, descriptionKey);
        }
    }
}

