/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.userprefs;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.internal.userprefs.PreferenceKey;
import io.github.nucleuspowered.nucleus.internal.userprefs.TargetID;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.PreferencesUserModule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

public class UserPreferenceService
implements NucleusUserPreferenceService {
    private final NucleusKeysProvider provider = new NucleusKeysProvider();
    private final Map<String, NucleusUserPreferenceService.PreferenceKey<?>> registered = new HashMap();
    private final Element element = new Element();
    public static final Text PREFERENCE_ARG = Text.of((String)"preference");
    public static final Text VALUE_ARG = Text.of((String)"value");

    public CommandElement getElement() {
        return this.element;
    }

    public void postInit() {
        Arrays.stream(NucleusKeysProvider.class.getDeclaredFields()).filter(x -> x.isAnnotationPresent(TargetID.class)).forEach(field -> {
            TargetID id = field.getAnnotation(TargetID.class);
            NucleusUserPreferenceService.PreferenceKey<?> key = this.registered.get(id.value());
            if (key != null) {
                try {
                    field.setAccessible(true);
                    field.set(this.provider, key);
                }
                catch (IllegalAccessException e) {
                    Nucleus.getNucleus().getLogger().error("Could not set " + id.value() + " in the User Preference Service", (Throwable)e);
                }
            }
        });
    }

    public void register(PreferenceKey<?> key) {
        if (this.registered.containsKey(key.getID())) {
            throw new IllegalArgumentException("ID already registered");
        }
        this.registered.put(key.getID(), key);
        this.element.keys.put(key.getID().toLowerCase().replaceAll("^nucleus:", ""), key);
        this.element.keys.put(key.getID().toLowerCase(), key);
    }

    public <T> void set(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key, @Nullable T value) {
        ((ModularUserService)Nucleus.getNucleus().getUserDataManager().get(uuid, true).orElseThrow(IllegalStateException::new)).get(PreferencesUserModule.class).set(key.getID(), value);
    }

    public Map<NucleusUserPreferenceService.PreferenceKey<?>, Object> get(User user) {
        HashMap ret = new HashMap();
        for (NucleusUserPreferenceService.PreferenceKey<?> key : this.registered.values()) {
            if (!key.canAccess(user)) continue;
            ret.put(key, this.get(user.getUniqueId(), key).orElse(null));
        }
        return ret;
    }

    public <T> Optional<T> get(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key) {
        if (!this.registered.containsValue(key)) {
            throw new IllegalArgumentException("Key is not registered.");
        }
        Optional<Object> ot = Optional.empty();
        try {
            ot = Nucleus.getNucleus().getUserDataManager().get(uuid).map(x -> x.get(PreferencesUserModule.class).get(key.getID()));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        if (ot.isPresent()) {
            return ot;
        }
        return key.getDefaultValue();
    }

    public <T> T getUnwrapped(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key) {
        return this.get(uuid, key).orElse(null);
    }

    @Override
    public NucleusUserPreferenceService.Keys keys() {
        return this.provider;
    }

    @Override
    public <T> Optional<T> getPreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<T> key) {
        return this.get(user.getUniqueId(), key);
    }

    @Override
    public <T> void setPreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<T> key, T value) {
        this.set(user.getUniqueId(), key, value);
    }

    @Override
    public void removePreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<?> key) {
        this.set(user.getUniqueId(), key, null);
    }

    Map<String, NucleusUserPreferenceService.PreferenceKey<?>> getRegistered() {
        return this.registered;
    }

    public static class Element
    extends CommandElement {
        private final Map<String, NucleusUserPreferenceService.PreferenceKey<?>> keys = new HashMap();

        Element() {
            super(null);
        }

        @Nullable
        public Text getKey() {
            return Text.of((String)"<preference> [value]");
        }

        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            String next = args.next().toLowerCase();
            Type type = this.parseFirst(source, args, context, next);
            if (args.hasNext()) {
                type.element.parse(source, args, context);
            }
        }

        private Type parseFirst(CommandSource source, CommandArgs args, CommandContext context, String next) throws ArgumentParseException {
            NucleusUserPreferenceService.PreferenceKey<?> key = this.keys.get(next);
            if (key != null) {
                Type type = null;
                Class<?> cls = key.getValueClass();
                if (cls == Boolean.TYPE || cls == Boolean.class) {
                    type = Type.BOOLEAN;
                } else if (cls == Integer.TYPE || cls == Integer.class) {
                    type = Type.INTEGER;
                } else if (cls == Double.TYPE || cls == Double.class) {
                    type = Type.DOUBLE;
                } else if (cls == String.class) {
                    type = Type.STRING;
                }
                if (type != null) {
                    this.checkAccess(key, this.getUser(source, args, context), args, source);
                    context.putArg(PREFERENCE_ARG, key);
                    return type;
                }
            }
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.userprefs.incorrect", next));
        }

        private void checkAccess(NucleusUserPreferenceService.PreferenceKey<?> key, User user, CommandArgs args, CommandSource source) throws ArgumentParseException {
            if (!key.canAccess(user)) {
                if (source instanceof Player && ((Player)source).getUniqueId().equals(user.getUniqueId())) {
                    throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.userprefs.noperm.self", key.getID()));
                }
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.userprefs.noperm.other", user.getName(), key.getID()));
            }
        }

        private User getUser(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            Optional o = context.getOne("user");
            if (!o.isPresent()) {
                if (source instanceof User) {
                    return (User)source;
                }
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.user.none", new String[0]));
            }
            return (User)o.get();
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                User user = this.getUser(src, args, context);
                CommandArgs.Snapshot snapshot = args.getSnapshot();
                String arg1 = args.next().toLowerCase();
                if (!args.hasNext()) {
                    args.applySnapshot(snapshot);
                    return this.keys.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(arg1)).filter(x -> ((NucleusUserPreferenceService.PreferenceKey)x.getValue()).canAccess(user)).map(Map.Entry::getKey).collect(Collectors.toList());
                }
                return this.parseFirst((CommandSource)src, (CommandArgs)args, (CommandContext)context, (String)arg1).element.complete(src, args, context);
            }
            catch (ArgumentParseException e) {
                return ImmutableList.of();
            }
        }

        public Text getUsage(CommandSource src) {
            return this.getKey();
        }

        private static enum Type {
            BOOLEAN(GenericArguments.bool((Text)VALUE_ARG)),
            DOUBLE(GenericArguments.doubleNum((Text)VALUE_ARG)),
            INTEGER(GenericArguments.integer((Text)VALUE_ARG)),
            STRING(GenericArguments.remainingRawJoinedStrings((Text)VALUE_ARG));

            final CommandElement element;

            private Type(CommandElement element) {
                this.element = element;
            }
        }
    }
}

