/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions
@RegisterCommand(value={"killentity"})
@NonnullByDefault
public class KillEntityCommand
extends AbstractCommand<CommandSource> {
    private static final String radius = "radius";
    private static final String world = "world";
    private static final String type = "type";
    private static final Predicate<Entity> armourStand = e -> e.getType().equals(EntityTypes.ARMOR_STAND);
    private static final Predicate<Entity> hostile = e -> e instanceof Monster;
    private static final Predicate<Entity> passive = e -> e instanceof Living && !(e instanceof Player) && !(e instanceof Monster);
    private final Map<String, ?> map = new HashMap<String, Predicate<Entity>>(){
        {
            this.put("armorstand", armourStand);
            this.put("armourstand", armourStand);
            this.put("monsters", hostile);
            this.put("hostile", hostile);
            this.put("passive", passive);
            this.put("animal", passive);
            this.put("item", e -> e instanceof Item);
            this.put("player", e -> e instanceof Player);
        }
    };

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().setAnchorFlags(true).valueFlag(GenericArguments.integer((Text)Text.of((String)radius)), new String[]{"r"}).valueFlag(NucleusParameters.WORLD_PROPERTIES_LOADED_ONLY, new String[]{"w"}).buildWith(GenericArguments.allOf((CommandElement)GenericArguments.choices((Text)Text.of((String)type), this.map)))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        HashSet currentEntities;
        if (!(src instanceof Locatable) && args.hasAny(radius)) {
            throw ReturnMessageException.fromKey("command.killentity.commandsourceradius", new Object[0]);
        }
        if (args.hasAny(radius) && args.hasAny(world)) {
            throw ReturnMessageException.fromKey("command.killentity.radiusworld", new Object[0]);
        }
        if (args.hasAny(radius)) {
            Locatable l = (Locatable)src;
            Vector3d locationTest = l.getLocation().getPosition();
            int r = (Integer)args.getOne(radius).get();
            currentEntities = Sets.newHashSet((Iterable)l.getWorld().getEntities(entity -> entity.getTransform().getPosition().distance(locationTest) <= (double)r));
        } else {
            WorldProperties worldProperties = this.getWorldFromUserOrArgs(src, world, args);
            currentEntities = Sets.newHashSet((Iterable)((World)Sponge.getServer().getWorld(worldProperties.getUniqueId()).get()).getEntities());
        }
        Predicate entityPredicate = (Predicate)args.getAll(type).stream().reduce(Predicate::or).orElseThrow(() -> ReturnMessageException.fromKey("command.killentity.noselection", new Object[0]));
        Set<Entity> toKill = currentEntities.stream().filter(entityPredicate).collect(Collectors.toSet());
        if (toKill.isEmpty()) {
            throw ReturnMessageException.fromKey("command.killentity.nothing", new Object[0]);
        }
        int killCount = toKill.size();
        toKill.forEach(x -> {
            x.offer(Keys.HEALTH, (Object)0.0);
            x.remove();
        });
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.killentity.success", String.valueOf(killCount)));
        return CommandResult.affectedEntities((int)killCount);
    }
}

