/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@Permissions
@RegisterCommand(value={"sudo"})
@EssentialsEquivalent(value={"sudo"})
@NonnullByDefault
public class SudoCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_PLAYER, NucleusParameters.COMMAND};
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("exempt.target", PermissionInformation.getWithTranslation("permission.sudo.exempt", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Player pl = (Player)args.getOne("player").get();
        String cmd = (String)args.getOne("command").get();
        if (pl.equals(src) || this.permissions.testSuffix((Subject)pl, "exempt.target", src, false)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sudo.noperms", new String[0]));
            return CommandResult.empty();
        }
        if (cmd.startsWith("c:")) {
            if (cmd.equals("c:")) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sudo.chatfail", new String[0]));
                return CommandResult.empty();
            }
            LiteralText rawMessage = Text.of((String)cmd.split(":", 2)[1]);
            try (CauseStackManager.StackFrame c = CauseStackHelper.createFrameWithCauses(EventContext.builder().add(EventContextKeys.PLAYER_SIMULATED, (Object)pl.getProfile()).build(), new Object[]{pl, src});){
                if (pl.simulateChat((Text)rawMessage, Sponge.getCauseStackManager().getCurrentCause()).isCancelled()) {
                    throw ReturnMessageException.fromKey("command.sudo.chatcancelled", new Object[0]);
                }
            }
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.sudo.force", pl.getName(), cmd));
        Sponge.getCommandManager().process((CommandSource)pl, cmd);
        return CommandResult.success();
    }
}

