/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.PermissionRegistry;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="nucleus", suggestedLevel=SuggestedLevel.OWNER)
@NoModifiers
@NonnullByDefault
@RunAsync
@RegisterCommand(value={"setupperms", "setperms"}, subcommandOf=NucleusCommand.class)
public class SetupPermissionsCommand
extends AbstractCommand<CommandSource> {
    private final PermissionRegistry permissionRegistry = Nucleus.getNucleus().getPermissionRegistry();
    private final String roleKey = "Nucleus Role";
    private final String groupKey = "Permission Group";
    private final String withGroupsKey = "-g";
    private final String acceptGroupKey = "-y";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.literal((Text)Text.of((String)this.withGroupsKey), (String[])new String[]{this.withGroupsKey}), GenericArguments.optional((CommandElement)GenericArguments.literal((Text)Text.of((String)this.acceptGroupKey), (String[])new String[]{this.acceptGroupKey}))}), GenericArguments.flags().flag(new String[]{"r", "-reset"}).flag(new String[]{"i", "-inherit"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.enumValue((Text)Text.of((String)this.roleKey), SuggestedLevel.class)), GenericArguments.onlyOne((CommandElement)new GroupArgument((Text)Text.of((String)this.groupKey)))}))})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        if (args.hasAny(this.withGroupsKey)) {
            if (ServiceChangeListener.isOpOnly()) {
                throw ReturnMessageException.fromKey("args.permissiongroup.noservice", new Object[0]);
            }
            if (args.hasAny(this.acceptGroupKey)) {
                this.setupGroups(src);
            } else {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.permission.groups.info", new String[0]));
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.permission.groups.info2", new String[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:nucleus setupperms -g -y")).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"/nucleus:nucleus setupperms -g -y"))).build());
            }
            return CommandResult.success();
        }
        SuggestedLevel sl = (SuggestedLevel)((Object)args.getOne(this.roleKey).get());
        Subject group = (Subject)args.getOne(this.groupKey).get();
        boolean reset = args.hasAny("r");
        boolean inherit = args.hasAny("i");
        this.setupPerms(src, group, sl, reset, inherit);
        return CommandResult.success();
    }

    private void setupGroups(CommandSource src) throws Exception {
        String ownerGroup = "owner";
        String adminGroup = "admin";
        String modGroup = "mod";
        String defaultGroup = "default";
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        PermissionService permissionService = (PermissionService)Sponge.getServiceManager().provide(PermissionService.class).orElseThrow(() -> ReturnMessageException.fromKey("args.permissiongroup.noservice", new Object[0]));
        Subject owner = this.getSubject(ownerGroup, src, permissionService, messageProvider);
        Subject admin = this.getSubject(adminGroup, src, permissionService, messageProvider);
        Subject mod = this.getSubject(modGroup, src, permissionService, messageProvider);
        Subject defaults = this.getSubject(defaultGroup, src, permissionService, messageProvider);
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.permission.inherit", adminGroup, ownerGroup));
        owner.getSubjectData().addParent((Set)ImmutableSet.of(), admin.asSubjectReference());
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.permission.inherit", modGroup, adminGroup));
        admin.getSubjectData().addParent((Set)ImmutableSet.of(), mod.asSubjectReference());
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.permission.inherit", defaultGroup, modGroup));
        mod.getSubjectData().addParent((Set)ImmutableSet.of(), defaults.asSubjectReference());
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.permission.perms", new String[0]));
        this.setupPerms(src, owner, SuggestedLevel.OWNER, false, false);
        this.setupPerms(src, admin, SuggestedLevel.ADMIN, false, false);
        this.setupPerms(src, mod, SuggestedLevel.MOD, false, false);
        this.setupPerms(src, defaults, SuggestedLevel.USER, false, false);
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.permission.completegroups", new String[0]));
    }

    private Subject getSubject(String group, CommandSource src, PermissionService service, MessageProvider provider) {
        return service.getGroupSubjects().getSubject(group).orElseGet(() -> {
            src.sendMessage(provider.getTextMessageWithFormat("command.nucleus.permission.create", group));
            return (Subject)service.getGroupSubjects().loadSubject(group).join();
        });
    }

    private void setupPerms(CommandSource src, Subject group, SuggestedLevel level, boolean reset, boolean inherit) {
        if (inherit && level.getLowerLevel() != null) {
            this.setupPerms(src, group, level.getLowerLevel(), reset, inherit);
        }
        HashSet globalContext = Sets.newHashSet();
        SubjectData data = group.getSubjectData();
        Set definedPermissions = data.getPermissions((Set)ImmutableSet.of()).keySet();
        Logger logger = Nucleus.getNucleus().getLogger();
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        this.permissionRegistry.getPermissions().entrySet().stream().filter(x -> ((PermissionInformation)x.getValue()).level == level).filter(x -> reset || !definedPermissions.contains(x.getKey())).forEach(x -> {
            logger.info(messageProvider.getMessageWithFormat("command.nucleus.permission.added", (String)x.getKey(), group.getIdentifier()));
            data.setPermission(globalContext, (String)x.getKey(), Tristate.TRUE);
        });
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.permission.complete", level.toString().toLowerCase(), group.getIdentifier()));
    }

    private static class GroupArgument
    extends CommandElement {
        GroupArgument(@Nullable Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String a = args.next();
            Optional<String> ls = this.getGroups(args).stream().filter(x -> x.equalsIgnoreCase(a)).findFirst();
            if (ls.isPresent()) {
                return ((PermissionService)Sponge.getServiceManager().provide(PermissionService.class).get()).getGroupSubjects().getSubject(ls.get()).get();
            }
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.permissiongroup.nogroup", a));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                String a = args.peek();
                return this.getGroups(args).stream().filter(x -> x.toLowerCase().contains(a)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }

        private Set<String> getGroups(CommandArgs args) throws ArgumentParseException {
            Optional ops = Sponge.getServiceManager().provide(PermissionService.class);
            if (!ops.isPresent()) {
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.permissiongroup.noservice", new String[0]));
            }
            PermissionService ps = (PermissionService)ops.get();
            try {
                return Sets.newHashSet((Iterable)((Iterable)ps.getGroupSubjects().getAllIdentifiers().get()));
            }
            catch (Exception e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.permissiongroup.failed", new String[0]));
            }
        }
    }
}

