/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.WeatherArgument;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularWorldService;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.environment.config.EnvironmentConfig;
import io.github.nucleuspowered.nucleus.modules.environment.config.EnvironmentConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.environment.datamodule.EnvironmentWorldDataModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weather;

@Permissions
@RegisterCommand(value={"weather"})
@NonnullByDefault
@EssentialsEquivalent(value={"thunder", "sun", "weather", "sky", "storm", "rain"})
public class WeatherCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final String weather = "weather";
    private long max = Long.MAX_VALUE;

    @Override
    public void onReload() {
        this.max = ((EnvironmentConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(EnvironmentConfigAdapter.class).getNodeOrDefault()).getMaximumWeatherTimespan();
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("exempt.length", PermissionInformation.getWithTranslation("permission.weather.exempt.length", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_WEAK_WORLD_PROPERTIES_ENABLED_ONLY, GenericArguments.onlyOne((CommandElement)new WeatherArgument((Text)Text.of((String)this.weather))), NucleusParameters.OPTIONAL_DURATION};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties wp = this.getWorldFromUserOrArgs(src, "world", args);
        World w = (World)Sponge.getServer().getWorld(wp.getUniqueId()).orElseThrow(() -> ReturnMessageException.fromKey("args.worldproperties.notloaded", wp.getWorldName()));
        ModularWorldService ew = Nucleus.getNucleus().getWorldDataManager().getWorld(w).get();
        if (ew.get(EnvironmentWorldDataModule.class).isLockWeather()) {
            throw ReturnMessageException.fromKey("command.weather.locked", w.getName());
        }
        Weather we = (Weather)args.getOne(this.weather).get();
        Optional oi = args.getOne("duration");
        if (this.max > 0L && oi.orElse(Long.MAX_VALUE) > this.max && !this.permissions.testSuffix((Subject)src, "exempt.length")) {
            throw ReturnMessageException.fromKey("command.weather.toolong", Util.getTimeStringFromSeconds(this.max));
        }
        if (oi.isPresent()) {
            w.setWeather(we, (Long)oi.get() * 20L);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.weather.time", we.getName(), w.getName(), Util.getTimeStringFromSeconds((Long)oi.get())));
        } else {
            w.setWeather(we);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.weather.set", we.getName(), w.getName()));
        }
        return CommandResult.success();
    }
}

