/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(supportsOthers=true)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"god", "invuln", "invulnerability"})
@EssentialsEquivalent(value={"god", "godmode", "tgm"})
public class GodCommand
extends AbstractCommand<CommandSource> {
    public static final String PVP_OVERRIDE = "pvp.override";

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put(PVP_OVERRIDE, PermissionInformation.getWithTranslation("permission.god.pvp.override", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)this.requirePermissionArg(NucleusParameters.ONE_PLAYER, this.permissions.getOthers()))), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Player pl = this.getUserFromArgs(Player.class, src, "player", args);
        InvulnerabilityService service = (InvulnerabilityService)this.getServiceUnchecked(InvulnerabilityService.class);
        boolean god = args.getOne("true|false").orElse(!service.isInvulnerable((User)pl));
        service.setInvulnerable((User)pl, god);
        if (!pl.equals(src)) {
            src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(god ? "command.god.player.on" : "command.god.player.off", pl.getName())});
        }
        pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(god ? "command.god.on" : "command.god.off", new String[0]));
        return CommandResult.success();
    }
}

