/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
abstract class LoreSetBaseCommand
extends AbstractCommand<Player> {
    LoreSetBaseCommand() {
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.LORE};
    }

    CommandResult setLore(Player src, String message, boolean replace) throws Exception {
        List loreList;
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> ReturnMessageException.fromKey("command.lore.set.noitem", new Object[0]));
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        Text getLore = TextSerializers.FORMATTING_CODE.deserialize(message);
        if (replace) {
            loreList = Lists.newArrayList((Object[])new Text[]{getLore});
        } else {
            loreList = (List)loreData.lore().get();
            loreList.add(getLore);
        }
        if (stack.offer(Keys.ITEM_LORE, (Object)loreList).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.lore.set.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.lore.set.fail", new Object[0]);
    }
}

