/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(supportsSelectors=true, supportsOthers=true)
@RegisterCommand(value={"top", "tosurface", "totop"})
@EssentialsEquivalent(value={"top"})
@NonnullByDefault
public class TopCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"f"}).buildWith(GenericArguments.optional((CommandElement)this.requirePermissionArg(NucleusParameters.ONE_PLAYER, this.permissions.getOthers())))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Player playerToTeleport = this.getUserFromArgs(Player.class, src, "player", args);
        Location location = playerToTeleport.getLocation();
        double x = location.getX();
        double z = location.getZ();
        Location start = new Location(location.getExtent(), x, (double)((World)location.getExtent()).getBlockMax().getY(), z);
        BlockRayHit end = (BlockRayHit)BlockRay.from((Location)start).stopFilter(BlockRay.onlyAirFilter()).to(playerToTeleport.getLocation().getPosition().sub(0.0f, 1.0f, 0.0f)).end().orElseThrow(() -> new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.nothingfound", new String[0])));
        if (playerToTeleport.getLocation().getBlockPosition().equals((Object)end.getBlockPosition())) {
            if (!playerToTeleport.equals(src)) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.attop.other", Nucleus.getNucleus().getNameUtil().getSerialisedName((User)playerToTeleport)));
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.attop.self", new String[0]));
        }
        NucleusTeleportHandler.TeleportResult result = Nucleus.getNucleus().getTeleportHandler().teleportPlayer(playerToTeleport, (Location<World>)end.getLocation(), !args.hasAny("f"));
        if (result.isSuccess()) {
            if (!playerToTeleport.equals(src)) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.success.other", Nucleus.getNucleus().getNameUtil().getSerialisedName((User)playerToTeleport)));
            }
            playerToTeleport.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.success.self", new String[0]));
            return CommandResult.success();
        }
        if (result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.notsafe", new String[0]));
        }
        throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.top.cancelled", new String[0]));
    }
}

