/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.exceptions.KitRedeemException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.api.service.NucleusKitService;
import io.github.nucleuspowered.nucleus.configurate.datatypes.KitDataNode;
import io.github.nucleuspowered.nucleus.dataservices.KitService;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfig;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.kit.datamodules.KitUserDataModule;
import io.github.nucleuspowered.nucleus.modules.kit.events.KitEvent;
import io.github.nucleuspowered.nucleus.modules.kit.misc.KitRedeemResult;
import io.github.nucleuspowered.nucleus.modules.kit.misc.SingleKit;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;

@APIService(value=NucleusKitService.class)
public class KitHandler
implements NucleusKitService,
Reloadable,
InternalServiceManagerTrait,
MessageProviderTrait,
PermissionTrait,
ServiceBase {
    private static final InventoryTransactionResult EMPTY_ITR = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).build();
    private static final Pattern inventory = Pattern.compile("\\{\\{.+?}}");
    private boolean isProcessTokens = false;
    private boolean isMustGetAll = false;
    private final CommandPermissionHandler cph = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(KitCommand.class);
    private final List<Container> viewers = Lists.newArrayList();
    private final Map<Container, Tuple<Kit, Inventory>> inventoryKitMap = Maps.newHashMap();
    private final KitService store = Nucleus.getNucleus().getKitService();
    @Nullable
    private Boolean hasViewersWorks = null;

    public static String getPermissionForKit(String kitName) {
        return "nucleus.kits." + kitName.toLowerCase();
    }

    public boolean exists(String name, boolean includeHidden) {
        return this.store.getKitNames(includeHidden).stream().anyMatch(x -> x.equalsIgnoreCase(name));
    }

    @Override
    public Set<String> getKitNames() {
        return this.getKitNames(true);
    }

    public Set<String> getKitNames(boolean showHidden) {
        return this.store.getKitNames(showHidden);
    }

    @Override
    public Optional<Kit> getKit(String name) {
        return this.store.getKit(name).map(x -> new SingleKit(name, (KitDataNode)x));
    }

    @Override
    public Collection<ItemStack> getItemsForPlayer(Kit kit, Player player) {
        Collection cis = kit.getStacks().stream().map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        if (this.isProcessTokens) {
            this.processTokensInItemStacks(player, cis);
        }
        return cis;
    }

    @Override
    public NucleusKitService.RedeemResult redeemKit(Kit kit, Player player, boolean performChecks) throws KitRedeemException {
        return this.redeemKit(kit, player, performChecks, performChecks, this.isMustGetAll, false, Nucleus.getNucleus().getUserDataManager().getUnchecked(player.getUniqueId()).get(KitUserDataModule.class));
    }

    @Override
    public NucleusKitService.RedeemResult redeemKit(Kit kit, Player player, boolean performChecks, boolean mustRedeemAll) throws KitRedeemException {
        return this.redeemKit(kit, player, performChecks, performChecks, mustRedeemAll, false, Nucleus.getNucleus().getUserDataManager().getUnchecked(player.getUniqueId()).get(KitUserDataModule.class));
    }

    public NucleusKitService.RedeemResult redeemKit(Kit kit, Player player, boolean checkOneTime, boolean checkCooldown, boolean isMustGetAll, boolean isFirstJoin, KitUserDataModule user) throws KitRedeemException {
        Instant timeOfLastUse = user.getLastRedeemedTime(kit.getName());
        Instant now = Instant.now();
        if ((checkOneTime || checkCooldown) && timeOfLastUse != null) {
            Optional<Duration> duration;
            if (checkOneTime && !this.checkOneTime(kit, player)) {
                throw new KitRedeemException("Already redeemed", KitRedeemException.Reason.ALREADY_REDEEMED);
            }
            if (checkCooldown && (duration = this.checkCooldown(kit, player, timeOfLastUse)).isPresent()) {
                throw new KitRedeemException.Cooldown("Cooldown not expired", duration.get());
            }
        }
        Cause cause = CauseStackHelper.createCause(player);
        KitEvent.PreRedeem preEvent = new KitEvent.PreRedeem(cause, timeOfLastUse, kit, player);
        if (Sponge.getEventManager().post((Event)preEvent)) {
            throw new KitRedeemException.PreCancelled(preEvent.getCancelMessage().orElse(null));
        }
        ArrayList slotList = Lists.newArrayList();
        Util.getStandardInventory((Carrier)player).slots().forEach(x -> slotList.add(x.peek().map(ItemStack::createSnapshot)));
        InventoryTransactionResult inventoryTransactionResult = EMPTY_ITR;
        if (!kit.getStacks().isEmpty()) {
            inventoryTransactionResult = this.addToStandardInventory(player, kit.getStacks(), this.isProcessTokens);
            if (!isFirstJoin && !inventoryTransactionResult.getRejectedItems().isEmpty() && isMustGetAll) {
                Inventory inventory = Util.getStandardInventory((Carrier)player);
                Iterator slot = inventory.slots().iterator();
                slotList.forEach(x -> {
                    Inventory i = (Inventory)slot.next();
                    i.clear();
                    x.ifPresent(y -> i.offer(y.createStack()));
                });
                throw new KitRedeemException("No free slots in player inventory", KitRedeemException.Reason.NO_SPACE);
            }
        }
        if (inventoryTransactionResult.getType() == InventoryTransactionResult.Type.SUCCESS) {
            kit.redeemKitCommands(player);
            if (checkCooldown) {
                user.addKitLastUsedTime(kit.getName(), now);
            }
            Sponge.getEventManager().post((Event)new KitEvent.PostRedeem(cause, timeOfLastUse, kit, player));
            return new KitRedeemResult(inventoryTransactionResult.getRejectedItems(), slotList.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }
        Sponge.getEventManager().post((Event)new KitEvent.FailedRedeem(cause, timeOfLastUse, kit, player));
        throw new KitRedeemException("No items were redeemed", KitRedeemException.Reason.UNKNOWN);
    }

    public boolean checkOneTime(Kit kit, Player player) {
        return !kit.isOneTime() || this.hasPermission((Subject)player, this.cph.getPermissionWithSuffix("exempt.onetime"));
    }

    public Optional<Duration> checkCooldown(Kit kit, Player player, Instant timeOfLastUse) {
        Instant timeForNextUse;
        Instant now = Instant.now();
        if (timeOfLastUse != null && !this.cph.testCooldownExempt((Subject)player) && kit.getCooldown().map(Duration::getSeconds).orElse(0L) > 0L && (timeForNextUse = timeOfLastUse.plus(kit.getCooldown().get())).isAfter(now)) {
            return Optional.of(Duration.between(now, timeForNextUse));
        }
        return Optional.empty();
    }

    @Override
    public boolean removeKit(String kitName) {
        if (this.store.removeKit(kitName)) {
            this.store.save();
            return true;
        }
        return false;
    }

    @Override
    public void saveKit(Kit kit) {
        this.saveKitInternal(kit.getName(), kit);
    }

    private synchronized void saveKitInternal(String name, Kit kit) {
        Preconditions.checkArgument((boolean)(kit instanceof SingleKit));
        Util.getKeyIgnoreCase(this.store.getKitNames(true), name).ifPresent(this.store::removeKit);
        this.store.addKit(name, kit);
        this.store.save();
    }

    @Override
    public Kit createKit(String name) throws IllegalArgumentException {
        Optional<String> key = Util.getKeyIgnoreCase(this.store.getKitNames(true), name);
        key.ifPresent(s -> {
            throw new IllegalArgumentException("Kit " + name + " already exists!");
        });
        return new SingleKit(name);
    }

    @Override
    public void renameKit(String kitName, String newKitName) throws IllegalArgumentException {
        Kit targetKit = this.getKit(kitName).orElseThrow(() -> new IllegalArgumentException(this.getMessageString("kit.noexists", kitName)));
        if (Util.getKeyIgnoreCase(this.getKitNames(), newKitName).isPresent()) {
            throw new IllegalArgumentException(this.getMessageString("kit.cannotrename", kitName, newKitName));
        }
        this.saveKitInternal(newKitName, targetKit);
        this.removeKit(kitName);
    }

    public Optional<Tuple<Kit, Inventory>> getCurrentlyOpenInventoryKit(Container inventory) {
        return Optional.ofNullable(this.inventoryKitMap.get(inventory));
    }

    public boolean isOpen(String kitName) {
        return this.inventoryKitMap.values().stream().anyMatch(x -> ((Kit)x.getFirst()).getName().equalsIgnoreCase(kitName));
    }

    public void addKitInventoryToListener(Tuple<Kit, Inventory> kit, Container inventory) {
        Preconditions.checkState((!this.inventoryKitMap.containsKey(inventory) ? 1 : 0) != 0);
        this.inventoryKitMap.put(inventory, kit);
    }

    public void removeKitInventoryFromListener(Container inventory) {
        this.inventoryKitMap.remove(inventory);
    }

    public void addViewer(Container inventory) {
        this.viewers.add(inventory);
    }

    public void removeViewer(Container inventory) {
        this.viewers.remove(inventory);
        if (this.hasViewersWorks == null) {
            try {
                inventory.hasViewers();
                this.hasViewersWorks = true;
            }
            catch (Throwable throwable) {
                this.hasViewersWorks = false;
                return;
            }
        }
        if (this.hasViewersWorks.booleanValue()) {
            this.viewers.removeIf(x -> !x.hasViewers());
        }
    }

    public boolean isViewer(Container inventory) {
        return this.viewers.contains(inventory);
    }

    public void processTokensInItemStacks(Player player, Collection<ItemStack> stacks) {
        Matcher m = inventory.matcher("");
        for (ItemStack x : stacks) {
            x.get(Keys.DISPLAY_NAME).ifPresent(text -> {
                if (m.reset(text.toPlain()).find()) {
                    x.offer(Keys.DISPLAY_NAME, (Object)NucleusTextTemplateFactory.createFromAmpersandString(TextSerializers.FORMATTING_CODE.serialize(text)).getForCommandSource((CommandSource)player, null, null));
                }
            });
            x.get(Keys.ITEM_LORE).ifPresent(text -> {
                if (text.stream().map(Text::toPlain).anyMatch(y -> m.reset((CharSequence)y).find())) {
                    x.offer(Keys.ITEM_LORE, text.stream().map(y -> NucleusTextTemplateFactory.createFromAmpersandString(TextSerializers.FORMATTING_CODE.serialize(y)).getForCommandSource((CommandSource)player, null, null)).collect(Collectors.toList()));
                }
            });
        }
    }

    private InventoryTransactionResult addToStandardInventory(Player player, Collection<ItemStackSnapshot> itemStacks, boolean replaceTokensInLore) {
        Inventory target = Util.getStandardInventory((Carrier)player);
        InventoryTransactionResult.Builder resultBuilder = InventoryTransactionResult.builder();
        Collection toOffer = itemStacks.stream().filter(x -> x.getType() != ItemTypes.NONE).map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        if (replaceTokensInLore) {
            this.processTokensInItemStacks(player, toOffer);
        }
        boolean success = false;
        for (ItemStack stack : toOffer) {
            InventoryTransactionResult itr = target.offer(stack);
            success = success || itr.getType() == InventoryTransactionResult.Type.SUCCESS;
            for (ItemStackSnapshot iss : itr.getRejectedItems()) {
                resultBuilder.reject(new ItemStack[]{iss.createStack()});
            }
        }
        return resultBuilder.type(success ? InventoryTransactionResult.Type.SUCCESS : InventoryTransactionResult.Type.FAILURE).build();
    }

    @Override
    public void onReload() {
        KitConfig kitConfig = (KitConfig)this.getServiceUnchecked(KitConfigAdapter.class).getNodeOrDefault();
        this.isMustGetAll = kitConfig.isMustGetAll();
        this.isProcessTokens = kitConfig.isProcessTokens();
    }
}

