/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nameban.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.RegexArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.modules.nameban.config.NameBanConfig;
import io.github.nucleuspowered.nucleus.modules.nameban.config.NameBanConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.nameban.services.NameBanHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"nameban"})
public class NameBanCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final String nameKey = "name";
    private final NameBanHandler handler = (NameBanHandler)this.getServiceUnchecked(NameBanHandler.class);
    private String defaultReason = "Your name is inappropriate";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new RegexArgument((Text)Text.of((String)this.nameKey), "[0-9a-zA-Z_]{3,16}", "command.nameban.notvalid", (commandSource, commandArgs, commandContext) -> {
            try {
                String arg = commandArgs.peek().toLowerCase();
                return Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(arg)).map(User::getName).collect(Collectors.toList());
            }
            catch (Exception e) {
                return Lists.newArrayList();
            }
        }), NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String name = ((String)args.getOne(this.nameKey).get()).toLowerCase();
        String reason = args.getOne("reason").orElse(this.defaultReason);
        if (this.handler.addName(name, reason, CauseStackHelper.createCause(src))) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nameban.success", name));
            return CommandResult.success();
        }
        throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nameban.failed", name));
    }

    @Override
    public void onReload() {
        this.defaultReason = ((NameBanConfig)((NameBanConfigAdapter)this.getServiceUnchecked(NameBanConfigAdapter.class)).getNodeOrDefault()).getDefaultReason();
    }
}

