/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.note.config.NoteConfig;
import io.github.nucleuspowered.nucleus.modules.note.config.NoteConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class NoteListener
implements ListenerBase.Conditional {
    private final NoteHandler handler = this.getServiceUnchecked(NoteHandler.class);
    private final String showOnLogin = "nucleus.note.showonlogin";

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            List<NoteData> notes = this.handler.getNotesInternal((User)player);
            if (notes != null && !notes.isEmpty()) {
                MutableMessageChannel messageChannel = new PermissionMessageChannel(this.showOnLogin).asMutable();
                messageChannel.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("note.login.notify", player.getName(), String.valueOf(notes.size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("note.login.view", player.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/checknotes " + player.getName()))).build());
            }
        }).submit((Object)Nucleus.getNucleus());
    }

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap mp = Maps.newHashMap();
        mp.put(this.showOnLogin, PermissionInformation.getWithTranslation("permission.note.showonlogin", SuggestedLevel.MOD));
        return mp;
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("note", NoteConfigAdapter.class, NoteConfig::isShowOnLogin).orElse(false);
    }
}

