/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.commands;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.rtp.RTPKernel;
import io.github.nucleuspowered.nucleus.api.service.NucleusRTPService;
import io.github.nucleuspowered.nucleus.internal.CostCancellableTask;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.SetCooldownManually;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.rtp.config.RTPConfig;
import io.github.nucleuspowered.nucleus.modules.rtp.config.RTPConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.rtp.events.RTPSelectedLocationEvent;
import io.github.nucleuspowered.nucleus.modules.rtp.options.RTPOptions;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.TypedAbstractConfigAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@SetCooldownManually
@NonnullByDefault
@Permissions(supportsOthers=true)
@RegisterCommand(value={"rtp", "randomteleport", "rteleport"})
public class RandomTeleportCommand
extends AbstractCommand.SimpleTargetOtherPlayer
implements Reloadable {
    private RTPConfig rc = new RTPConfig();
    private final Map<Task, UUID> cachedTasks = new WeakHashMap<Task, UUID>();
    private final Timing TIMINGS = Timings.of((Object)Nucleus.getNucleus(), (String)"RTP task");

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("worlds", PermissionInformation.getWithTranslation("permission.rtp.worlds", SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandElement[] additionalArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY, this.permissions.getPermissionWithSuffix("world")))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandResult executeWithPlayer(CommandSource src, Player player, CommandContext args, boolean self) throws Exception {
        World currentWorld;
        Map<Task, UUID> map = this.cachedTasks;
        synchronized (map) {
            this.cachedTasks.keySet().removeIf(task -> !Sponge.getScheduler().getTaskById(task.getUniqueId()).isPresent());
            if (this.cachedTasks.containsValue(player.getUniqueId())) {
                throw ReturnMessageException.fromKey("command.rtp.inprogress", player.getName());
            }
        }
        WorldProperties wp = this.rc.getDefaultWorld().isPresent() ? args.getOne("world").orElseGet(() -> this.rc.getDefaultWorld().get()) : this.getWorldFromUserOrArgs(src, "world", args);
        if (this.rc.isPerWorldPermissions()) {
            String name = wp.getWorldName();
            this.permissions.checkSuffix((Subject)src, "worlds." + name.toLowerCase(), () -> ReturnMessageException.fromKey("command.rtp.worldnoperm", name));
        }
        if ((currentWorld = (World)Sponge.getServer().loadWorld(wp.getUniqueId()).orElse(null)) == null) {
            currentWorld = (World)Sponge.getServer().loadWorld(wp).orElseThrow(() -> ReturnMessageException.fromKey("command.rtp.worldnoload", wp.getWorldName()));
        }
        this.sendMessageTo(src, "command.rtp.searching");
        RTPOptions options = new RTPOptions(this.rc, currentWorld.getName());
        RTPTask rtask = new RTPTask(currentWorld, src, player, this.rc.getNoOfAttempts(), options, this.rc.getKernel(wp.getWorldName()), this.getCost(src, args));
        Task task2 = Sponge.getScheduler().createTaskBuilder().execute((Consumer)rtask).submit((Object)Nucleus.getNucleus());
        this.cachedTasks.put(task2, player.getUniqueId());
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        this.rc = Nucleus.getNucleus().getConfigAdapter("rtp", RTPConfigAdapter.class).map(TypedAbstractConfigAdapter::getNodeOrDefault).orElseGet(RTPConfig::new);
    }

    static /* synthetic */ Timing access$100(RandomTeleportCommand x0) {
        return x0.TIMINGS;
    }

    private class RTPTask
    extends CostCancellableTask {
        private final Cause cause;
        private final World targetWorld;
        private final CommandSource source;
        private final Player target;
        private final boolean isSelf;
        private int count;
        private final int maxCount;
        private final NucleusRTPService.RTPOptions options;
        private final RTPKernel kernel;

        private RTPTask(World target, CommandSource source, Player target1, int maxCount, NucleusRTPService.RTPOptions options, RTPKernel kernel, double cost) {
            super(Nucleus.getNucleus(), source, cost);
            this.cause = Sponge.getCauseStackManager().getCurrentCause();
            this.targetWorld = target;
            this.source = source;
            this.target = target1;
            this.isSelf = source instanceof Player && ((Player)source).getUniqueId().equals(target1.getUniqueId());
            this.maxCount = maxCount;
            this.count = maxCount;
            this.options = options;
            this.kernel = kernel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(Task task) {
            block27: {
                block28: {
                    block25: {
                        block26: {
                            --this.count;
                            if (!this.target.isOnline()) {
                                this.onCancel();
                                return;
                            }
                            dummy = RandomTeleportCommand.access$100(RandomTeleportCommand.this).startTiming();
                            var3_3 = null;
                            try {
                                Nucleus.getNucleus().getLogger().debug(String.format("RTP of %s, attempt %s of %s", new Object[]{this.target.getName(), this.maxCount - this.count, this.maxCount}));
                                counter = 0;
                                while (++counter <= 10) {
                                    try {
                                        optionalLocation = this.kernel.getLocation((Location<World>)this.target.getLocation(), this.targetWorld, this.options);
                                        if (!optionalLocation.isPresent()) continue;
                                        targetLocation = optionalLocation.get();
                                        if (Sponge.getEventManager().post((Event)new RTPSelectedLocationEvent(targetLocation, this.target, this.cause))) continue;
                                        Nucleus.getNucleus().getLogger().debug(String.format("RTP of %s, found location %s, %s, %s", new Object[]{this.target.getName(), String.valueOf(targetLocation.getBlockX()), String.valueOf(targetLocation.getBlockY()), String.valueOf(targetLocation.getBlockZ())}));
                                        if (NucleusTeleportHandler.setLocation(this.target, targetLocation)) {
                                            if (!this.isSelf) {
                                                RandomTeleportCommand.this.sendMessageTo((CommandSource)this.target, "command.rtp.other");
                                                RandomTeleportCommand.this.sendMessageTo(this.source, "command.rtp.successother", new Object[]{this.target.getName(), targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ()});
                                            }
                                            RandomTeleportCommand.this.sendMessageTo((CommandSource)this.target, "command.rtp.success", new Object[]{targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ()});
                                            if (this.isSelf) {
                                                RandomTeleportCommand.this.setCooldown(this.target);
                                                var7_10 = RandomTeleportCommand.access$200(RandomTeleportCommand.this);
                                                synchronized (var7_10) {
                                                    RandomTeleportCommand.access$200(RandomTeleportCommand.this).remove(task);
                                                }
                                            }
                                            if (dummy == null) return;
                                            if (var3_3 == null) break block25;
                                            break block26;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (PositionOutOfBoundsException var5_8) {
                                    }
                                }
                                break block27;
                            }
                            catch (Throwable var4_6) {
                                try {
                                    var3_3 = var4_6;
                                    throw var4_6;
                                }
                                catch (Throwable var9_13) {
                                    if (dummy == null) throw var9_13;
                                    if (var3_3 == null) {
                                        dummy.close();
                                        throw var9_13;
                                    }
                                    try {
                                        dummy.close();
                                        throw var9_13;
                                    }
                                    catch (Throwable var10_14) {
                                        var3_3.addSuppressed(var10_14);
                                        throw var9_13;
                                    }
                                }
                            }
                        }
                        try {
                            dummy.close();
                            return;
                        }
                        catch (Throwable var7_11) {
                            var3_3.addSuppressed(var7_11);
                            return;
                        }
                    }
                    dummy.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        RandomTeleportCommand.this.sendMessageTo(this.source, "command.rtp.cancelled");
                        this.onCancel();
                        if (dummy == null) return;
                        if (var3_3 == null) break block28;
                    }
                    try {
                        dummy.close();
                        return;
                    }
                    catch (Throwable var7_12) {
                        var3_3.addSuppressed(var7_12);
                        return;
                    }
                }
                dummy.close();
                return;
            }
            this.onUnsuccesfulAttempt(task);
            if (dummy == null) return;
            if (var3_3 != null) {
                try {
                    dummy.close();
                    return;
                }
                catch (Throwable var4_5) {
                    var3_3.addSuppressed(var4_5);
                    return;
                }
            }
            dummy.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnsuccesfulAttempt(Task task) {
            Map map = RandomTeleportCommand.this.cachedTasks;
            synchronized (map) {
                if (this.count <= 0) {
                    Nucleus.getNucleus().getLogger().debug(String.format("RTP of %s was unsuccessful", this.subject.getName()));
                    RandomTeleportCommand.this.sendMessageTo(this.subject, "command.rtp.error");
                    this.onCancel();
                } else {
                    RandomTeleportCommand.this.cachedTasks.put(Sponge.getScheduler().createTaskBuilder().delayTicks(2L).execute((Consumer)this).submit((Object)Nucleus.getNucleus()), this.target.getUniqueId());
                }
                RandomTeleportCommand.this.cachedTasks.remove(task);
            }
        }
    }
}

