/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.config;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.internal.qsml.NucleusConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.rtp.config.RTPConfig;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import java.util.List;
import ninja.leaping.configurate.ConfigurationNode;

public class RTPConfigAdapter
extends NucleusConfigAdapter.StandardWithSimpleDefault<RTPConfig> {
    @Override
    protected void manualTransform(ConfigurationNode node) {
        this.nodeTransform(node);
        node.getNode(new Object[]{"world-overrides"}).getChildrenMap().forEach((key, value) -> this.nodeTransform((ConfigurationNode)value));
    }

    private void nodeTransform(ConfigurationNode node) {
        if (node.getNode(new Object[]{"default-method"}).isVirtual() && !node.getNode(new Object[]{"center-on-player"}).isVirtual() && !node.getNode(new Object[]{"surface-only"}).isVirtual()) {
            boolean centreOnPlayer = node.getNode(new Object[]{"center-on-player"}).getBoolean(false);
            boolean surfaceonly = node.getNode(new Object[]{"surface-only"}).getBoolean(false);
            if (centreOnPlayer) {
                if (surfaceonly) {
                    node.getNode(new Object[]{"default-method"}).setValue((Object)"nucleus:around_player_surface");
                } else {
                    node.getNode(new Object[]{"default-method"}).setValue((Object)"nucleus:around_player");
                }
            } else if (surfaceonly) {
                node.getNode(new Object[]{"default-method"}).setValue((Object)"nucleus:surface_only");
            } else {
                node.getNode(new Object[]{"default-method"}).setValue((Object)"nucleus:default");
            }
        }
    }

    @Override
    protected List<AbstractConfigAdapter.Transformation> getTransformations() {
        return Lists.newArrayList((Object[])new AbstractConfigAdapter.Transformation[]{new AbstractConfigAdapter.Transformation(new Object[]{"center-on-player"}, (inputPath, valueAtPath) -> null), new AbstractConfigAdapter.Transformation(new Object[]{"surface-only"}, (inputPath, valueAtPath) -> null)});
    }

    public RTPConfigAdapter() {
        super(RTPConfig.class);
    }
}

