/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.servershop.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.EconHelper;
import io.github.nucleuspowered.nucleus.internal.annotations.RequiresEconomy;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@RequiresEconomy
@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"itemsell", "sell"})
@EssentialsEquivalent(value={"sell"})
@NonnullByDefault
public class SellCommand
extends AbstractCommand<Player> {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private final EconHelper econHelper = Nucleus.getNucleus().getEconHelper();

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        ItemStack is = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.generalerror.handempty", new String[0])));
        Optional blockState = is.get(Keys.ITEM_BLOCKSTATE);
        String id = blockState.map(blockState1 -> blockState1.getId().toLowerCase()).orElseGet(() -> is.getType().getId());
        ItemDataNode node = this.itemDataService.getDataForItem(id);
        double sellPrice = node.getServerSellPrice();
        if (sellPrice < 0.0) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itemsell.notforselling", new String[0]));
            return CommandResult.empty();
        }
        int amt = is.getQuantity();
        double overallCost = sellPrice * (double)amt;
        if (this.econHelper.depositInPlayer((User)src, overallCost, false)) {
            src.setItemInHand(HandTypes.MAIN_HAND, null);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsell.summary", new Text[]{Text.of((Object[])new Object[]{amt}), Text.of((Translatable)is, (Object[])new Object[0]), Text.of((String)this.econHelper.getCurrencySymbol(overallCost))}));
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsell.error", new Text[]{Text.of((Translatable)is, (Object[])new Object[0])}));
        return CommandResult.empty();
    }
}

