/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.modules.spawn.helpers.SpawnHelper;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"spawn"})
@EssentialsEquivalent(value={"spawn"})
@NonnullByDefault
public class SpawnCommand
extends AbstractCommand<Player>
implements Reloadable {
    private SpawnConfig sc = new SpawnConfig();
    private final String key = "world";

    @Override
    public void onReload() {
        this.sc = (SpawnConfig)((SpawnConfigAdapter)this.getServiceUnchecked(SpawnConfigAdapter.class)).getNodeOrDefault();
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("force", PermissionInformation.getWithTranslation("permission.spawn.force", SuggestedLevel.ADMIN));
        m.put("otherworlds", PermissionInformation.getWithTranslation("permission.spawn.otherworlds", SuggestedLevel.ADMIN));
        m.put("worlds", PermissionInformation.getWithTranslation("permission.spawn.worlds", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("force"), new String[]{"f", "-force"}).buildWith(GenericArguments.optional((CommandElement)this.requirePermissionArg(GenericArguments.onlyOne((CommandElement)GenericArguments.world((Text)Text.of((String)this.key))), this.permissions.getPermissionWithSuffix("otherworlds"))))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        boolean force = args.hasAny("f");
        GlobalSpawnConfig gsc = this.sc.getGlobalSpawn();
        WorldProperties wp = args.getOne(this.key).orElseGet(() -> gsc.isOnSpawnCommand() ? gsc.getWorld().orElse(src.getWorld().getProperties()) : src.getWorld().getProperties());
        Optional ow = Sponge.getServer().loadWorld(wp.getUniqueId());
        if (!ow.isPresent()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawn.noworld", new String[0]));
        }
        if (this.sc.isPerWorldPerms() && !this.permissions.testSuffix((Subject)src, "worlds." + ((World)ow.get()).getName().toLowerCase())) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawn.nopermsworld", ((World)ow.get()).getName()));
        }
        Transform<World> worldTransform = SpawnHelper.getSpawn(wp, src);
        SendToSpawnEvent event = new SendToSpawnEvent(worldTransform, (User)src, CauseStackHelper.createCause(src));
        if (Sponge.getEventManager().post((Event)event)) {
            if (event.getCancelReason().isPresent()) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.self.failed.reason", event.getCancelReason().get()));
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.self.failed.noreason", new String[0]));
        }
        NucleusTeleportHandler.TeleportResult result = Nucleus.getNucleus().getTeleportHandler().teleportPlayer(src, SpawnHelper.getSpawn(((World)ow.get()).getProperties(), src), !force && this.sc.isSafeTeleport(), true);
        if (result.isSuccess()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawn.success", wp.getWorldName()));
            return CommandResult.success();
        }
        if (result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION) {
            throw ReturnMessageException.fromKey("command.spawn.fail", wp.getWorldName());
        }
        throw ReturnMessageException.fromKey("command.spawn.cancelled", wp.getWorldName());
    }
}

