/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.listeners;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.spawn.datamodules.SpawnGeneralDataModule;
import io.github.nucleuspowered.nucleus.modules.spawn.datamodules.SpawnWorldDataModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class SpawnListener
implements Reloadable,
ListenerBase,
MessageProviderTrait {
    private SpawnConfig spawnConfig;
    private final String spawnExempt = "nucleus.spawn.exempt.login";

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap mpi = Maps.newHashMap();
        mpi.put(this.spawnExempt, PermissionInformation.getWithTranslation("permission.spawn.exempt.login", SuggestedLevel.ADMIN));
        return mpi;
    }

    @Listener
    public void onJoin(ClientConnectionEvent.Login loginEvent) {
        block11: {
            UUID pl = loginEvent.getProfile().getUniqueId();
            boolean first = !Nucleus.getNucleus().getUserDataManager().getUnchecked(pl).get(CoreUserDataModule.class).getFirstJoin().isPresent();
            try {
                Optional<Transform<World>> ofs;
                if (first && (ofs = Nucleus.getNucleus().getGeneralService().get(SpawnGeneralDataModule.class).getFirstSpawn()).isPresent()) {
                    Location location = this.spawnConfig.isSafeTeleport() ? (Location)Sponge.getTeleportHelper().getSafeLocation(ofs.get().getLocation()).orElse(null) : ofs.get().getLocation();
                    if (location != null) {
                        loginEvent.setToTransform(new Transform(location.getExtent(), SpawnListener.process(location.getPosition()), ofs.get().getRotation()));
                        return;
                    }
                    Nucleus.getNucleus().getLogger().warn(this.getMessageString("spawn.firstspawn.failed", loginEvent.getProfile().getName().orElse(this.getMessageString("standard.unknown", new String[0]))));
                }
            }
            catch (Exception e) {
                if (!Nucleus.getNucleus().isDebugMode()) break block11;
                e.printStackTrace();
            }
        }
        User user = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(loginEvent.getProfile());
        if (this.spawnConfig.isSpawnOnLogin() && !this.hasPermission((Subject)user, this.spawnExempt)) {
            World world = (World)loginEvent.getFromTransform().getExtent();
            String worldName = world.getName();
            String uuid = world.getUniqueId().toString();
            if (this.spawnConfig.getOnLoginExemptWorlds().stream().anyMatch(x -> x.equalsIgnoreCase(worldName) || x.equalsIgnoreCase(uuid))) {
                return;
            }
            GlobalSpawnConfig sc = this.spawnConfig.getGlobalSpawn();
            if (sc.isOnLogin() && sc.getWorld().isPresent()) {
                world = Sponge.getServer().getWorld(sc.getWorld().get().getUniqueId()).orElse(world);
            }
            Location lw = world.getSpawnLocation().add(0.5, 0.0, 0.5);
            Optional<Location<World>> safe = Nucleus.getNucleus().getTeleportHandler().getSafeLocation(null, (Location<World>)lw, this.spawnConfig.isSafeTeleport() ? NucleusTeleportHandler.StandardTeleportMode.SAFE_TELEPORT_ASCENDING : NucleusTeleportHandler.StandardTeleportMode.NO_CHECK);
            if (safe.isPresent()) {
                try {
                    Optional<Vector3d> ov = Nucleus.getNucleus().getWorldDataManager().getWorld(world.getUniqueId()).get().get(SpawnWorldDataModule.class).getSpawnRotation();
                    if (ov.isPresent()) {
                        loginEvent.setToTransform(new Transform(safe.get().getExtent(), SpawnListener.process(safe.get().getPosition()), ov.get()));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                loginEvent.setToTransform(new Transform(SpawnListener.process(safe.get())));
            }
        }
    }

    @Listener(order=Order.EARLY)
    public void onPlayerWorldTransfer(MoveEntityEvent.Teleport event) {
        Transform to;
        if (event.getTargetEntity() instanceof Player && !((World)event.getFromTransform().getExtent()).equals(event.getToTransform().getExtent()) && (to = event.getToTransform()).getLocation().getBlockPosition().equals((Object)((World)to.getExtent()).getSpawnLocation().getBlockPosition())) {
            Nucleus.getNucleus().getWorldDataManager().getWorld((World)to.getExtent()).ifPresent(x -> x.get(SpawnWorldDataModule.class).getSpawnRotation().ifPresent(y -> event.setToTransform(to.setRotation(y))));
        }
    }

    @Listener(order=Order.EARLY)
    public void onRespawn(RespawnPlayerEvent event) {
        Optional<WorldProperties> oworld;
        if (event.isBedSpawn() && !this.spawnConfig.isRedirectBedSpawn()) {
            return;
        }
        GlobalSpawnConfig sc = this.spawnConfig.getGlobalSpawn();
        World world = (World)event.getToTransform().getExtent();
        if (sc.isOnRespawn() && (oworld = sc.getWorld()).isPresent()) {
            world = Sponge.getServer().getWorld(oworld.get().getUniqueId()).orElse(world);
        }
        Location spawn = world.getSpawnLocation().add(0.5, 0.0, 0.5);
        Transform to = new Transform(spawn);
        Nucleus.getNucleus().getWorldDataManager().getWorld(world).ifPresent(x -> x.get(SpawnWorldDataModule.class).getSpawnRotation().ifPresent(y -> event.setToTransform(to.setRotation(y))));
    }

    @Override
    public void onReload() {
        this.spawnConfig = (SpawnConfig)this.getServiceUnchecked(SpawnConfigAdapter.class).getNodeOrDefault();
    }

    private static Location<World> process(Location<World> v3d) {
        return new Location(v3d.getExtent(), SpawnListener.process(v3d.getPosition()));
    }

    private static Vector3d process(Vector3d v3d) {
        return v3d.floor().add(0.5, 0.0, 0.5);
    }
}

