/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.services;

import com.flowpowered.math.GenericMath;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularWorldService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.world.commands.border.GenerateChunksCommand;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.world.datamodules.WorldgenWorldDataModule;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.spongepowered.api.event.world.ChunkPreGenerationEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class WorldHelper
implements Reloadable,
ServiceBase {
    private boolean notify = false;
    private boolean display = true;
    private long timeToNotify = 20000L;
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0.##");
    private static final String TIME_FORMAT = "s's 'S'ms'";
    private static final String notifyPermission = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(GenerateChunksCommand.class).getPermissionWithSuffix("notify");
    private final Map<UUID, ChunkPreGenerate> pregen = Maps.newHashMap();

    public boolean isPregenRunningForWorld(UUID uuid) {
        this.cleanup();
        return this.pregen.containsKey(uuid);
    }

    @Override
    public void onReload() {
        WorldConfig config = Nucleus.getNucleus().getConfigValue("world", WorldConfigAdapter.class, c -> c).orElseGet(WorldConfig::new);
        this.notify = config.isDisplayAfterEachGen();
        this.display = config.isDisplayWarningGeneration();
        this.timeToNotify = config.getNotificationInterval() * 1000L;
    }

    public boolean startPregenningForWorld(World world, boolean aggressive, long saveTime, @Nullable Integer tickPercent, @Nullable Integer tickFrequency, boolean onRestart) {
        this.cleanup();
        if (!this.isPregenRunningForWorld(world.getUniqueId())) {
            WorldProperties wp = world.getProperties();
            ChunkPreGenerate.Builder wbcp = world.newChunkPreGenerate(wp.getWorldBorderCenter(), wp.getWorldBorderDiameter()).owner((Object)Nucleus.getNucleus()).addListener((Consumer)new Listener(aggressive, saveTime));
            if (aggressive) {
                wbcp.tickPercentLimit(0.9f).tickInterval(3);
            }
            if (tickPercent != null) {
                wbcp.tickPercentLimit(Math.max(0.0f, Math.min((float)tickPercent.intValue() / 100.0f, 1.0f)));
            } else {
                tickPercent = aggressive ? 90 : 80;
            }
            if (tickFrequency != null) {
                wbcp.tickInterval(Math.max(1, tickFrequency));
            } else {
                tickFrequency = 4;
            }
            if (onRestart) {
                ModularWorldService service = (ModularWorldService)Nucleus.getNucleus().getWorldDataManager().get(world.getUniqueId(), true).get();
                WorldgenWorldDataModule module = service.get(WorldgenWorldDataModule.class);
                module.setStart(true).setAggressive(aggressive).setSaveTime(saveTime).setTickFreq(tickFrequency).setTickPercent(tickPercent);
                service.set(module);
                service.save();
            }
            this.pregen.put(world.getUniqueId(), wbcp.start());
            return true;
        }
        return false;
    }

    public boolean cancelPregenRunningForWorld(UUID uuid) {
        this.cleanup();
        if (this.pregen.containsKey(uuid)) {
            ChunkPreGenerate cpg = this.pregen.remove(uuid);
            this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.cancelled2", String.valueOf(cpg.getTotalGeneratedChunks()), String.valueOf(cpg.getTotalSkippedChunks()), DurationFormatUtils.formatDuration((long)cpg.getTotalTime().toMillis(), (String)TIME_FORMAT, (boolean)false)));
            cpg.cancel();
            return true;
        }
        return false;
    }

    private synchronized void cleanup() {
        this.pregen.entrySet().removeIf(x -> ((ChunkPreGenerate)x.getValue()).isCancelled());
    }

    private MessageChannel getChannel() {
        return MessageChannel.combined((MessageChannel[])new MessageChannel[]{MessageChannel.TO_CONSOLE, MessageChannel.permission((String)notifyPermission)});
    }

    private class Listener
    implements Consumer<ChunkPreGenerationEvent> {
        private final boolean aggressive;
        private final long timeToSave;
        private boolean highMemTriggered = false;
        private long time = 0L;
        private long lastSaveTime;
        private long lastNotifyTime;

        public Listener(boolean aggressive, long timeToSave) {
            this.aggressive = aggressive;
            this.lastSaveTime = System.currentTimeMillis();
            this.timeToSave = timeToSave;
        }

        @Override
        public void accept(ChunkPreGenerationEvent event) {
            ChunkPreGenerate cpg = event.getChunkPreGenerate();
            if (event instanceof ChunkPreGenerationEvent.Pre) {
                if (!this.aggressive) {
                    long percent = this.getMemPercent();
                    if (percent >= 90L) {
                        if (!this.highMemTriggered) {
                            event.getTargetWorld().getLoadedChunks().forEach(Chunk::unloadChunk);
                            this.save(event.getTargetWorld());
                            NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.memory.high", String.valueOf(percent));
                            this.highMemTriggered = true;
                            this.save(event.getTargetWorld());
                        }
                        ((ChunkPreGenerationEvent.Pre)event).setSkipStep(true);
                    } else if (this.highMemTriggered && percent <= 80L) {
                        this.highMemTriggered = false;
                        NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.memory.low", new String[0]);
                    }
                }
            } else if (event instanceof ChunkPreGenerationEvent.Post) {
                long time;
                ChunkPreGenerationEvent.Post cpp = (ChunkPreGenerationEvent.Post)event;
                this.time += cpp.getTimeTakenForStep().toMillis();
                Text message = cpp.getChunksSkippedThisStep() > 0 ? NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.notifyskipped", String.valueOf(cpp.getChunksGeneratedThisStep()), String.valueOf(cpp.getChunksSkippedThisStep()), DurationFormatUtils.formatDuration((long)cpp.getTimeTakenForStep().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpp.getChunkPreGenerate().getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), String.valueOf(GenericMath.floor((float)(cpg.getTotalGeneratedChunks() * 100 / cpg.getTargetTotalChunks())))) : NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.notify", String.valueOf(cpp.getChunksGeneratedThisStep()), DurationFormatUtils.formatDuration((long)cpp.getTimeTakenForStep().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpp.getChunkPreGenerate().getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false), String.valueOf(GenericMath.floor((float)(cpg.getTotalGeneratedChunks() * 100 / cpg.getTargetTotalChunks()))));
                if (WorldHelper.this.notify) {
                    WorldHelper.this.getChannel().send(message);
                }
                if (this.lastSaveTime + this.timeToSave < (time = System.currentTimeMillis())) {
                    this.save(event.getTargetWorld());
                }
                if (WorldHelper.this.display && this.lastNotifyTime + WorldHelper.this.timeToNotify < time) {
                    MessageChannel.TO_ALL.send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.all", new String[0]));
                    double total = (double)(100 * (cpg.getTotalGeneratedChunks() + cpg.getTotalSkippedChunks())) / (double)cpg.getTargetTotalChunks();
                    WorldHelper.this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.quickstatus", PERCENT_FORMAT.format(total), String.valueOf(cpg.getTotalGeneratedChunks() + cpg.getTotalSkippedChunks()), String.valueOf(cpg.getTargetTotalChunks())));
                    this.lastNotifyTime = time;
                }
            } else if (event instanceof ChunkPreGenerationEvent.Complete) {
                WorldHelper.this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.completed", String.valueOf(cpg.getTotalGeneratedChunks()), String.valueOf(cpg.getTotalSkippedChunks()), DurationFormatUtils.formatDuration((long)this.time, (String)WorldHelper.TIME_FORMAT, (boolean)false), DurationFormatUtils.formatDuration((long)cpg.getTotalTime().toMillis(), (String)WorldHelper.TIME_FORMAT, (boolean)false)));
                ModularWorldService m = Nucleus.getNucleus().getWorldDataManager().getWorld(event.getTargetWorld()).get();
                m.set(m.get(WorldgenWorldDataModule.class).setStart(false));
                m.save();
            }
        }

        private long getMemPercent() {
            long max = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            long total = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long free = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            return (max - total + free) * 100L / max;
        }

        private void save(World world) {
            WorldHelper.this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.saving", new String[0]));
            try {
                world.save();
                WorldHelper.this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.saved", new String[0]));
            }
            catch (Throwable e) {
                WorldHelper.this.getChannel().send(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.pregen.gen.savefailed", new String[0]));
                e.printStackTrace();
            }
            finally {
                this.lastSaveTime = System.currentTimeMillis();
            }
        }
    }
}

