/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import me.desht.pneumaticcraft.common.block.tubes.ModuleAirGrate;
import me.desht.pneumaticcraft.common.block.tubes.ModuleCharging;
import me.desht.pneumaticcraft.common.block.tubes.ModuleFlowDetector;
import me.desht.pneumaticcraft.common.block.tubes.ModuleLogistics;
import me.desht.pneumaticcraft.common.block.tubes.ModulePressureGauge;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegulatorTube;
import me.desht.pneumaticcraft.common.block.tubes.ModuleSafetyValve;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ModuleRegistrator {
    private static final HashMap<String, Class<? extends TubeModule>> module2class = new HashMap();
    private static final HashMap<String, Item> module2Item = new HashMap();

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleSafetyValve());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModulePressureGauge());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleFlowDetector());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleAirGrate());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleRegulatorTube());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleCharging());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleLogistics());
        ModuleRegistrator.registerModule((IForgeRegistry<Item>)registry, new ModuleRedstone());
    }

    private static void registerModule(IForgeRegistry<Item> registry, TubeModule module) {
        ItemTubeModule moduleItem = new ItemTubeModule(module.getType());
        Itemss.registerItem(registry, moduleItem);
        module2class.put(module.getType(), module.getClass());
        module2Item.put(module.getType(), moduleItem);
    }

    public static TubeModule getModule(String moduleName) {
        Class<? extends TubeModule> clazz = module2class.get(moduleName);
        if (clazz == null) {
            Log.error("No tube module found for the name \"" + moduleName + "\"!");
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Item getModuleItem(String moduleName) {
        return module2Item.get(moduleName);
    }
}

