/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.common.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberGlass;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.event.VillagerHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressureChamberValve
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IAirListener {
    private static final int CHAMBER_INV_SIZE = 27;
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    @DescSynced
    public boolean hasGlass;
    @DescSynced
    private float roundedPressure;
    public List<TileEntityPressureChamberValve> accessoryValves;
    private final List<BlockPos> nbtValveList;
    private boolean readNBT = false;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public float recipePressure;
    @DescSynced
    private ItemStackHandler itemsInChamber = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileEntityPressureChamberValve.this.recipeRecalcNeeded = true;
        }
    };
    private final List<IPressureChamberRecipe> applicableRecipes = new ArrayList<IPressureChamberRecipe>();
    private boolean recipeRecalcNeeded = true;
    private long lastSoundTick;
    private int nParticles;

    public TileEntityPressureChamberValve() {
        super(5.0f, 7.0f, 16000, 4);
        this.accessoryValves = new ArrayList<TileEntityPressureChamberValve>();
        this.nbtValveList = new ArrayList<BlockPos>();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        switch (this.getRotation()) {
            case UP: 
            case DOWN: {
                return side == EnumFacing.UP || side == EnumFacing.DOWN;
            }
            case NORTH: 
            case SOUTH: {
                return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
            }
            case EAST: 
            case WEST: {
                return side == EnumFacing.EAST || side == EnumFacing.WEST;
            }
        }
        return false;
    }

    @Override
    public void addConnectedPneumatics(List<Pair<EnumFacing, IAirHandler>> teList) {
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                if (valve == this) continue;
                teList.add((Pair<EnumFacing, IAirHandler>)new ImmutablePair(null, (Object)valve.getAirHandler(null)));
            }
        }
    }

    @Override
    public void onAirDispersion(IAirHandler handler, EnumFacing dir, int airAdded) {
    }

    @Override
    public int getMaxDispersion(IAirHandler handler, EnumFacing dir) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void func_73660_a() {
        if (this.readNBT && !this.func_145831_w().field_72995_K) {
            this.doPostNBTSetup();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.checkForAirLeak();
        }
        if (this.multiBlockSize != 0 && !this.func_145831_w().field_72995_K) {
            this.roundedPressure = (float)((int)(this.getPressure() * 4.0f)) / 4.0f;
            if (this.recipeRecalcNeeded) {
                this.isValidRecipeInChamber = false;
                this.isSufficientPressureInChamber = false;
                this.recipePressure = Float.MAX_VALUE;
                this.applicableRecipes.clear();
                for (IPressureChamberRecipe recipe : PressureChamberRecipe.recipes) {
                    if (!recipe.isValidRecipe(this.itemsInChamber)) continue;
                    this.applicableRecipes.add(recipe);
                }
                this.isValidRecipeInChamber = !this.applicableRecipes.isEmpty();
                this.recipeRecalcNeeded = false;
            }
            this.processApplicableRecipes();
            if (this.getPressure() > 1.0f) {
                this.handleEntitiesInChamber();
            }
        }
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K && this.hasGlass && this.isPrimaryValve() && (double)this.roundedPressure > 0.2 && PneumaticCraftRepressurized.proxy.getClientPlayer().func_174818_b(this.func_174877_v()) < 256.0) {
            for (int i = 0; i < this.nParticles; ++i) {
                double posX = (double)this.multiBlockX + 1.0 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posY = (double)this.multiBlockY + 1.5 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.5);
                double posZ = (double)this.multiBlockZ + 1.0 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.0);
                PneumaticCraftRepressurized.proxy.playCustomParticle(EnumCustomParticleType.AIR_PARTICLE, this.field_145850_b, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private void doPostNBTSetup() {
        this.readNBT = false;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockPressureChamberValve) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockPressureChamberValve.FORMED, (Comparable)Boolean.valueOf(this.isPrimaryValve())), 2);
        }
        this.accessoryValves.clear();
        for (BlockPos valve : this.nbtValveList) {
            TileEntity te = this.func_145831_w().func_175625_s(valve);
            if (!(te instanceof TileEntityPressureChamberValve)) continue;
            this.accessoryValves.add((TileEntityPressureChamberValve)te);
        }
        if (this.isPrimaryValve()) {
            this.hasGlass = this.checkForGlass();
            this.sendDescriptionPacket();
        }
    }

    private void checkForAirLeak() {
        TileEntityPressureChamberValve primaryValve;
        boolean[] connected = new boolean[]{true, true, true, true, true, true};
        switch (this.getRotation()) {
            case UP: 
            case DOWN: {
                connected[EnumFacing.DOWN.ordinal()] = false;
                connected[EnumFacing.UP.ordinal()] = false;
                break;
            }
            case NORTH: 
            case SOUTH: {
                connected[EnumFacing.SOUTH.ordinal()] = false;
                connected[EnumFacing.NORTH.ordinal()] = false;
                break;
            }
            case EAST: 
            case WEST: {
                connected[EnumFacing.WEST.ordinal()] = false;
                connected[EnumFacing.EAST.ordinal()] = false;
            }
        }
        List<Pair<EnumFacing, IAirHandler>> teList = this.getAirHandler(null).getConnectedPneumatics();
        for (Pair<EnumFacing, IAirHandler> entry : teList) {
            if (entry.getKey() == null) continue;
            connected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
        TileEntityPressureChamberValve tileEntityPressureChamberValve = primaryValve = this.accessoryValves.isEmpty() ? null : this.accessoryValves.get(this.accessoryValves.size() - 1);
        if (primaryValve != null) {
            switch (this.getRotation()) {
                case UP: 
                case DOWN: {
                    if (primaryValve.multiBlockY == this.func_174877_v().func_177956_o()) {
                        connected[EnumFacing.UP.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.DOWN.ordinal()] = true;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (primaryValve.multiBlockZ == this.func_174877_v().func_177952_p()) {
                        connected[EnumFacing.SOUTH.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.NORTH.ordinal()] = true;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (primaryValve.multiBlockX == this.func_174877_v().func_177958_n()) {
                        connected[EnumFacing.EAST.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.WEST.ordinal()] = true;
                }
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (connected[i]) continue;
            this.getAirHandler(null).airLeak(EnumFacing.func_82600_a((int)i));
        }
    }

    private void processApplicableRecipes() {
        for (IPressureChamberRecipe recipe : this.applicableRecipes) {
            boolean pressureOK;
            boolean bl = pressureOK = recipe.getCraftingPressure() <= this.getPressure() && recipe.getCraftingPressure() > 0.0f || recipe.getCraftingPressure() >= this.getPressure() && recipe.getCraftingPressure() < 0.0f;
            if (Math.abs(recipe.getCraftingPressure()) < Math.abs(this.recipePressure)) {
                this.recipePressure = recipe.getCraftingPressure();
            }
            if (!pressureOK) continue;
            this.isSufficientPressureInChamber = true;
            this.giveOutput(recipe.craftRecipe(this.itemsInChamber));
            if (this.func_145831_w().func_82737_E() - this.lastSoundTick <= 5L) break;
            NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187665_Y, SoundCategory.BLOCKS, this.func_174877_v(), 0.5f, 0.8f + this.func_145831_w().field_73012_v.nextFloat() * 0.4f, false), this.func_145831_w());
            this.lastSoundTick = this.func_145831_w().func_82737_E();
            break;
        }
    }

    private void handleEntitiesInChamber() {
        AxisAlignedBB bbBox = new AxisAlignedBB((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
        List entities = this.func_145831_w().func_72872_a(EntityLivingBase.class, bbBox);
        for (EntityLivingBase entity : entities) {
            EntityVillager villager;
            if (entity instanceof EntityVillager && (villager = (EntityVillager)entity).getProfessionForge() != VillagerHandler.mechanicProfession) {
                villager.func_70106_y();
                EntityVillager mechanic = new EntityVillager(this.field_145850_b);
                mechanic.setProfession(VillagerHandler.mechanicProfession);
                mechanic.func_70107_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v);
                this.field_145850_b.func_72838_d((Entity)mechanic);
            }
            if (entity instanceof EntityVillager && ((EntityVillager)entity).getProfessionForge() == VillagerHandler.mechanicProfession) continue;
            entity.func_70097_a((DamageSource)DamageSourcePneumaticCraft.PRESSURE, (float)((int)((double)this.getPressure() * 2.0)));
        }
    }

    private boolean checkForGlass() {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    if (!(this.field_145850_b.func_180495_p((BlockPos)(mPos = mPos.func_181079_c(this.multiBlockX + x, this.multiBlockY + y, this.multiBlockZ + z))).func_177230_c() instanceof BlockPressureChamberGlass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void giveOutput(NonNullList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            stack = stack.func_77946_l();
            if ((stack = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false)).func_190926_b()) continue;
            this.dropItemOnGround(stack);
        }
    }

    public ItemStackHandler getStacksInChamber() {
        return this.itemsInChamber;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        this.setMultiBlockCoords(tag.func_74762_e("multiBlockSize"), tag.func_74762_e("multiBlockX"), tag.func_74762_e("multiBlockY"), tag.func_74762_e("multiBlockZ"));
        this.isSufficientPressureInChamber = tag.func_74767_n("sufPressure");
        this.isValidRecipeInChamber = tag.func_74767_n("validRecipe");
        this.recipePressure = tag.func_74760_g("recipePressure");
        this.itemsInChamber.deserializeNBT(tag.func_74775_l("itemsInChamber"));
        if (this.itemsInChamber.getSlots() > 27) {
            ItemStackHandler newHandler = new ItemStackHandler(27);
            for (i = 0; i < 27; ++i) {
                newHandler.setStackInSlot(i, this.itemsInChamber.getStackInSlot(i));
            }
            this.itemsInChamber = newHandler;
        }
        NBTTagList tagList2 = tag.func_150295_c("Valves", 10);
        this.nbtValveList.clear();
        for (i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList2.func_150305_b(i);
            this.nbtValveList.add(NBTUtil.getPos(tagCompound));
        }
        this.readNBT = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("multiBlockX", this.multiBlockX);
        tag.func_74768_a("multiBlockY", this.multiBlockY);
        tag.func_74768_a("multiBlockZ", this.multiBlockZ);
        tag.func_74768_a("multiBlockSize", this.multiBlockSize);
        tag.func_74757_a("sufPressure", this.isSufficientPressureInChamber);
        tag.func_74757_a("validRecipe", this.isValidRecipeInChamber);
        tag.func_74776_a("recipePressure", this.recipePressure);
        tag.func_74782_a("itemsInChamber", (NBTBase)this.itemsInChamber.serializeNBT());
        NBTTagList tagList2 = new NBTTagList();
        for (TileEntityPressureChamberValve valve : this.accessoryValves) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("x", valve.func_174877_v().func_177958_n());
            tagCompound.func_74768_a("y", valve.func_174877_v().func_177956_o());
            tagCompound.func_74768_a("z", valve.func_174877_v().func_177952_p());
            tagList2.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Valves", (NBTBase)tagList2);
        return tag;
    }

    public void onMultiBlockBreak() {
        if (this.isPrimaryValve()) {
            Iterator<ItemStack> itemsInChamberIterator = new ItemStackHandlerIterable(this.itemsInChamber).iterator();
            while (itemsInChamberIterator.hasNext()) {
                ItemStack stack = itemsInChamberIterator.next();
                this.dropItemOnGround(stack);
                itemsInChamberIterator.remove();
            }
            this.invalidateMultiBlock();
        }
    }

    private void dropItemOnGround(ItemStack stack) {
        PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.func_145831_w(), (double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + 1.0, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0);
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ));
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                valve.setMultiBlockCoords(0, 0, 0, 0);
                if (valve == this) continue;
                valve.accessoryValves.clear();
                if (this.func_145831_w().field_72995_K) continue;
                valve.sendDescriptionPacket();
            }
            this.accessoryValves.clear();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    private void setMultiBlockCoords(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
        this.getAirHandler(null).setDefaultVolume(this.getDefaultVolume());
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.nParticles = IntMath.pow((int)(this.multiBlockSize - 2), (int)3);
        this.nParticles = Math.max(1, (int)((float)this.nParticles / (this.dangerPressure + 1.0f - Math.min(this.dangerPressure, this.roundedPressure))));
    }

    public static boolean checkIfProperlyFormed(World world, BlockPos pos) {
        for (int i = 3; i < 6; ++i) {
            if (!TileEntityPressureChamberValve.checkForShiftedCubeOfSize(i, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY)) {
                    return true;
                }
                if (!TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        ArrayList<TileEntityPressureChamberValve> valveList = new ArrayList<TileEntityPressureChamberValve>();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    mPos = mPos.func_181079_c(x + baseX, y + baseY, z + baseZ);
                    IBlockState state = world.func_180495_p((BlockPos)mPos);
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z != 0 && z != size - 1) {
                        if (world.func_175623_d((BlockPos)mPos)) continue;
                        return false;
                    }
                    if (!(state.func_177230_c() instanceof IBlockPressureChamber)) {
                        return false;
                    }
                    if (state.func_177230_c() instanceof BlockPressureChamberValve) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z != 0 && z != size - 1;
                        EnumFacing facing = (EnumFacing)state.func_177229_b(BlockPneumaticCraft.ROTATION);
                        if (xMid && yMid && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) || xMid && zMid && (facing == EnumFacing.UP || facing == EnumFacing.DOWN) || yMid && zMid && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
                            TileEntity te = world.func_175625_s((BlockPos)mPos);
                            if (!(te instanceof TileEntityPressureChamberValve)) continue;
                            valveList.add((TileEntityPressureChamberValve)te);
                            continue;
                        }
                        return false;
                    }
                    TileEntity te = world.func_175625_s((BlockPos)mPos);
                    if (!(te instanceof TileEntityPressureChamberWall) || ((TileEntityPressureChamberWall)te).getCore() == null) continue;
                    return false;
                }
            }
        }
        if (valveList.isEmpty()) {
            return false;
        }
        TileEntityPressureChamberValve primaryValve = (TileEntityPressureChamberValve)valveList.get(valveList.size() - 1);
        valveList.forEach(valve -> {
            valve.accessoryValves = new ArrayList<TileEntityPressureChamberValve>(valveList);
        });
        primaryValve.setMultiBlockCoords(size, baseX, baseY, baseZ);
        primaryValve.hasGlass = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    TileEntity te = world.func_175625_s(new BlockPos(x + baseX, y + baseY, z + baseZ));
                    if (te instanceof TileEntityPressureChamberWall) {
                        TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                        teWall.setCore(primaryValve);
                        if (world.func_180495_p(te.func_174877_v()).func_177230_c() instanceof BlockPressureChamberGlass) {
                            primaryValve.hasGlass = true;
                        }
                    } else if (te instanceof TileEntityPressureChamberValve) {
                        IBlockState state = world.func_180495_p(te.func_174877_v());
                        world.func_180501_a(te.func_174877_v(), state.func_177226_a((IProperty)BlockPressureChamberValve.FORMED, (Comparable)Boolean.valueOf(((TileEntityPressureChamberValve)te).isPrimaryValve())), 2);
                    }
                    if (te == null || te.func_145831_w().field_72995_K) continue;
                    double dx = x == 0 ? -0.1 : 0.1;
                    double dz = z == 0 ? -0.1 : 0.1;
                    NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, (double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5, dx, 0.3, dz, 5, 0.0, 0.0, 0.0), world);
                }
            }
        }
        primaryValve.captureEntityItemsInChamber();
        primaryValve.sendDescriptionPacket();
        return true;
    }

    private boolean isPrimaryValve() {
        return this.multiBlockSize > 0;
    }

    private AxisAlignedBB getChamberAABB() {
        return new AxisAlignedBB((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
    }

    private void captureEntityItemsInChamber() {
        List items = this.func_145831_w().func_175647_a(EntityItem.class, this.getChamberAABB(), EntitySelectors.field_94557_a);
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false);
            if (leftover.func_190926_b()) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(stack);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getChamberAABB();
    }

    @Override
    public String getName() {
        return Blockss.PRESSURE_CHAMBER_VALVE.func_149739_a();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -3.4028235E38f;
    }

    @Override
    public int getDefaultVolume() {
        int vol = super.getDefaultVolume();
        return this.multiBlockSize > 3 ? vol * IntMath.pow((int)(this.multiBlockSize - 2), (int)3) : vol;
    }
}

