/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.container.ContainerAutocraftingTable;
import trinsdar.ic2c_extras.util.StackHelper;
import trinsdar.ic2c_extras.util.int3;

public class TileEntityAutocraftingTable
extends TileEntityElecMachine
implements ITickable,
IHasGui {
    public static final ResourceLocation GUI_LOCATION = new ResourceLocation("ic2c_extras", "textures/gui/autocrafter.png");
    public ItemStack target;
    public NonNullList<ItemStack> craftingList = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    protected static final int[] slotInputs = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    protected static final int[] slotContainer = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18};
    protected static final int[] slotOutputs = new int[]{19};

    public TileEntityAutocraftingTable() {
        super(29, 32);
        this.maxEnergy = 10000;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, slotInputs);
        handler.registerDefaultSlotAccess(AccessRule.Export, slotOutputs);
        handler.registerDefaultSlotAccess(AccessRule.Export, slotContainer);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), slotInputs);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), slotOutputs);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, slotContainer);
        handler.registerInputFilter(CommonFilters.Anything, slotInputs);
        handler.registerSlotType(SlotType.Input, slotInputs);
        handler.registerSlotType(SlotType.Output, slotOutputs);
        handler.registerSlotType(SlotType.Output, slotContainer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Crafting", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= 9) continue;
            this.craftingList.set(slot, (Object)new ItemStack(data));
        }
        this.target = new ItemStack(nbt.func_74775_l("target"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.craftingList.size(); ++i) {
            if (i > 9) continue;
            NBTTagCompound data = new NBTTagCompound();
            ((ItemStack)this.craftingList.get(i)).func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        if (this.target != null) {
            nbt.func_74782_a("target", (NBTBase)this.target.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74782_a("Crafting", (NBTBase)list);
        return nbt;
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerAutocraftingTable(player.field_71071_by, this);
    }

    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return facing != this.getFacing() && facing.func_176740_k().func_176722_c();
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.tryImportItems();
            this.tryCondenseInventory();
            if (this.canAttemptToCraft() && ((ItemStack)this.inventory.get(19)).func_190926_b()) {
                ArrayList<ItemStack> resourceList = new ArrayList<ItemStack>();
                for (ItemStack stack : this.craftingList) {
                    if (stack.func_190926_b()) continue;
                    resourceList.add(stack.func_77946_l());
                }
                ArrayList<ItemStack> finalList = new ArrayList<ItemStack>();
                StackHelper.mergeItems(finalList, resourceList);
                int matched = 0;
                int needed = finalList.size();
                ArrayList<ItemStack> alreadyCounted = new ArrayList<ItemStack>();
                for (ItemStack neededStack : finalList) {
                    for (ItemStack storedStack : this.storedInventory()) {
                        if (!StackHelper.isEqualCompareOreDict(storedStack, neededStack) || StackHelper.contains(alreadyCounted, storedStack) != -1 || storedStack.func_190916_E() < neededStack.func_190916_E()) continue;
                        alreadyCounted.add(storedStack);
                        ++matched;
                    }
                }
                if (matched >= needed) {
                    ArrayList<ItemStack> alreadySubtracted = new ArrayList<ItemStack>();
                    boolean canContinue = true;
                    for (ItemStack neededStack : finalList) {
                        for (int i = 1; i < 10; ++i) {
                            ItemStack input = (ItemStack)this.inventory.get(i);
                            if (!StackHelper.isEqualCompareOreDict(input, neededStack) || StackHelper.contains(alreadySubtracted, neededStack) != -1) continue;
                            if (input.func_77973_b().hasContainerItem(input) || neededStack.func_77973_b().hasContainerItem(neededStack)) {
                                if (this.roomForContainerItems() == 0) {
                                    canContinue = false;
                                    return;
                                }
                                ItemStack container = input.func_77973_b().getContainerItem(input);
                                for (int k = 10; k < 19; ++k) {
                                    if (!((ItemStack)this.inventory.get(k)).func_190926_b() || !canContinue) continue;
                                    this.inventory.set(k, (Object)container.func_77946_l());
                                    break;
                                }
                            }
                            if (!canContinue) continue;
                            alreadySubtracted.add(neededStack);
                            input.func_190918_g(neededStack.func_190916_E());
                        }
                    }
                    if (canContinue) {
                        this.setStackInSlot(19, this.target.func_77946_l());
                        this.useEnergy(50);
                    }
                }
            }
            if (!((ItemStack)this.inventory.get(19)).func_190926_b()) {
                this.tryExportItems();
            }
        }
    }

    public List<ItemStack> storedInventory() {
        ArrayList<ItemStack> storedList = new ArrayList<ItemStack>();
        for (int i = 1; i < 10; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            storedList.add((ItemStack)this.inventory.get(i));
        }
        return storedList;
    }

    public int roomForContainerItems() {
        int emptySlots = 0;
        for (int i = 10; i < 19; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    public void tryCondenseInventory() {
        for (int i = 1; i < 10; ++i) {
            for (int j = 1; j < 10; ++j) {
                ItemStack stack1 = (ItemStack)this.inventory.get(i);
                ItemStack stack2 = (ItemStack)this.inventory.get(j);
                if (stack1.func_190926_b() || stack2.func_190926_b() || !StackHelper.isEqual(stack1, stack2) || stack1.func_190916_E() >= stack1.func_77976_d()) continue;
                int max = stack1.func_77976_d() - stack1.func_190916_E();
                int available = stack2.func_190916_E();
                int size = TileEntityAutocraftingTable.clip(available, 1, max);
                stack1.func_190917_f(size);
                stack2.func_190918_g(size);
            }
        }
    }

    public static int clip(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public boolean canAttemptToCraft() {
        if (this.target == null || this.target.func_190926_b()) {
            return false;
        }
        if (this.craftingList.stream().allMatch(e -> e.equals(ItemStack.field_190927_a))) {
            return false;
        }
        return this.energy >= 50;
    }

    public TileEntity getImportTile() {
        int3 dir = new int3(this.func_174877_v(), this.getFacing());
        return this.field_145850_b.func_175625_s(dir.left(1).asBlockPos());
    }

    public TileEntity getExportTile() {
        int3 dir = new int3(this.func_174877_v(), this.getFacing());
        return this.field_145850_b.func_175625_s(dir.right(1).asBlockPos());
    }

    public void tryImportItems() {
        ItemStack stack;
        IItemTransporter slave = TransporterManager.manager.getTransporter((Object)this.getImportTile(), true);
        if (slave == null) {
            return;
        }
        IItemTransporter controller = TransporterManager.manager.getTransporter((Object)this, true);
        int limit = 64;
        for (int i = 0; i < limit && !(stack = slave.removeItem(CommonFilters.Anything, this.getFacing().func_176734_d(), 1, false)).func_190926_b(); ++i) {
            this.getFacing();
            ItemStack added = controller.addItem(stack, EnumFacing.UP, true);
            if (added.func_190916_E() <= 0) break;
            slave.removeItem(CommonFilters.Anything, this.getFacing().func_176734_d(), 1, true);
        }
    }

    public void tryExportItems() {
        IItemTransporter slave = TransporterManager.manager.getTransporter((Object)this.getExportTile(), true);
        if (slave == null) {
            return;
        }
        IItemTransporter controller = TransporterManager.manager.getTransporter((Object)this, true);
        int limit = 64;
        for (int i = 0; i < limit; ++i) {
            this.getFacing();
            ItemStack stack = controller.removeItem(CommonFilters.Anything, EnumFacing.EAST, 1, false);
            if (stack.func_190926_b()) break;
            this.getFacing();
            ItemStack added = slave.addItem(stack, EnumFacing.UP, true);
            if (added.func_190916_E() <= 0) break;
            controller.removeItem(CommonFilters.Anything, this.getFacing().func_176734_d(), 1, true);
        }
    }

    public boolean supportsNotify() {
        return true;
    }

    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    public ResourceLocation getGuiTexture() {
        return GUI_LOCATION;
    }
}

