/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.mars.dimension;

import asmodeuscore.api.dimension.IProviderFreeze;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_Biome;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_ChunkProvider;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProvider;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_TerrainGenerator;
import galaxyspace.systems.SolarSystem.planets.mars.dimension.sky.SkyProviderMars;
import galaxyspace.systems.SolarSystem.planets.mars.world.gen.we.Mars_High_Plains;
import galaxyspace.systems.SolarSystem.planets.mars.world.gen.we.Mars_Mountains;
import galaxyspace.systems.SolarSystem.planets.mars.world.gen.we.Mars_Plains;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockBasicMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.BiomeDecoratorMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.BiomeProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.MapGenCavernMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.MapGenDungeonMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.RoomBossMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.RoomTreasureMars;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderMars_WE
extends WE_WorldProvider
implements IProviderFreeze {
    private final MapGenDungeon dungeonGenerator = new MapGenDungeonMars(new DungeonConfiguration(MarsBlocks.marsBlock.func_176223_P().func_177226_a((IProperty)BlockBasicMars.BASIC_TYPE, (Comparable)BlockBasicMars.EnumBlockBasic.DUNGEON_BRICK), 30, 8, 16, 7, 7, RoomBossMars.class, RoomTreasureMars.class));
    private final float[] colorsSunriseSunset = new float[4];

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 3.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public CelestialBody getCelestialBody() {
        return MarsModule.planetMars;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return WE_ChunkProvider.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderMars.class;
    }

    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.8235294f * f), (double)(0.47058824f * f), (double)(0.23137255f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.6039216f * f), (double)(0.44705883f * f), (double)(0.25882354f * f));
    }

    public boolean func_76561_g() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= 0.05f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.6f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.35f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 1.0f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderMars());
        }
        return super.getSkyRenderer();
    }

    public int getDungeonSpacing() {
        return 704;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public DimensionType func_186058_p() {
        return GCPlanetDimensions.MARS;
    }

    public void genSettings(WE_ChunkProvider cp) {
        cp.createChunkGen_List.clear();
        cp.createChunkGen_InXZ_List.clear();
        cp.createChunkGen_InXYZ_List.clear();
        cp.decorateChunkGen_List.clear();
        cp.CRATER_PROB = 400;
        WE_Biome.setBiomeMap((WE_ChunkProvider)cp, (double)1.2, (int)4, (double)800.0, (double)1.0);
        WE_TerrainGenerator terrainGenerator = new WE_TerrainGenerator();
        terrainGenerator.worldStoneBlock = MarsBlocks.marsBlock.func_176203_a(9);
        terrainGenerator.worldSeaGen = false;
        terrainGenerator.worldSeaGenBlock = Blocks.field_150355_j.func_176223_P();
        terrainGenerator.worldSeaGenMaxY = 64;
        cp.createChunkGen_List.add(terrainGenerator);
        WE_CaveGen cg = new WE_CaveGen();
        cg.replaceBlocksList.clear();
        cg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        cg.lavaMaxY = 0;
        cp.createChunkGen_List.add(cg);
        WE_RavineGen rg = new WE_RavineGen();
        rg.replaceBlocksList.clear();
        rg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        rg.addReplacingBlock(MarsBlocks.marsBlock.func_176203_a(6));
        rg.addReplacingBlock(MarsBlocks.marsBlock.func_176203_a(5));
        rg.addReplacingBlock(Blocks.field_150403_cj.func_176223_P());
        rg.lavaBlock = Blocks.field_150350_a.func_176223_P();
        rg.lavaMaxY = 0;
        cp.createChunkGen_List.add(rg);
        MapGenCavernMars cavernGenerator = new MapGenCavernMars();
        cp.worldGenerators.clear();
        cp.worldGenerators.add(cavernGenerator);
        cp.biomesList.clear();
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Mars_Plains(-1.0, 0.0));
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Mars_High_Plains(-0.5, 0.5));
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Mars_Mountains(-0.0, 1.0));
    }

    public BiomeDecoratorSpace getDecorator() {
        return new BiomeDecoratorMars();
    }

    public boolean enableAdvancedThermalLevel() {
        return super.enableAdvancedThermalLevel();
    }

    protected float getThermalValueMod() {
        return 1.4f;
    }

    public void onPopulate(int cX, int cZ) {
        this.dungeonGenerator.func_175794_a(this.field_76579_a, this.field_76579_a.field_73012_v, new ChunkPos(cX, cZ));
    }

    public void onChunkProvider(int cX, int cZ, ChunkPrimer primer) {
        this.dungeonGenerator.func_186125_a(this.field_76579_a, cX, cZ, primer);
    }

    public void recreateStructures(Chunk chunkIn, int x, int z) {
        this.dungeonGenerator.func_186125_a(this.field_76579_a, x, z, null);
    }
}

