/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.recipes;

import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSRecipeUtil;
import galaxyspace.systems.SolarSystem.moons.miranda.blocks.MirandaBlocks;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.AssemblyRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.RecyclerRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.RocketAssemblyRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidExtractor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.recipe.NasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.recipe.ShapedRecipeNBT;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CraftingRecipesOverworld {
    private static String plateIron = GSConfigCore.enablePlateOreDict ? "plateIron" : "compressedIron";
    private static String plateSteel = GSConfigCore.enablePlateOreDict ? "plateSteel" : "compressedSteel";
    private static String plateTitanium = GSConfigCore.enablePlateOreDict ? "plateTitanium" : "compressedTitanium";
    private static String plateBronze = GSConfigCore.enablePlateOreDict ? "plateBronze" : "compressedBronze";
    private static String plateTin = GSConfigCore.enablePlateOreDict ? "plateTin" : "compressedTin";
    private static String plateDesh = GSConfigCore.enablePlateOreDict ? "plateDesh" : "compressedDesh";
    private static String plateAluminum = GSConfigCore.enablePlateOreDict ? "plateAluminum" : "compressedAluminum";

    public static void loadRecipes() {
        CraftingRecipesOverworld.addBlockRecipes();
        CraftingRecipesOverworld.addItemRecipes();
        CraftingRecipesOverworld.addBlockSmelting();
        CraftingRecipesOverworld.addCompressor();
        CraftingRecipesOverworld.addAssembly();
        CraftingRecipesOverworld.addRocketAssembly();
        CraftingRecipesOverworld.addRecycler();
        CraftingRecipesOverworld.addCircuitFabricator();
        CraftingRecipesOverworld.addOtherRecipes();
    }

    private static void addBlockRecipes() {
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 4, 0), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 4, 1), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateMagnesium", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 4, 2), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateNickel", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 4, 3), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateCopper", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 1, 4), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 1, 5), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotNickel"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DECO_METALS, 1, 6), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotMagnesium"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.INGOTS, 9, 0), (Object[])new Object[]{"X", Character.valueOf('X'), new ItemStack(GSBlocks.DECO_METALS, 1, 4)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.INGOTS, 9, 1), (Object[])new Object[]{"X", Character.valueOf('X'), new ItemStack(GSBlocks.DECO_METALS, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.INGOTS, 9, 2), (Object[])new Object[]{"X", Character.valueOf('X'), new ItemStack(GSBlocks.DECO_METALS, 1, 5)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FUTURE_GLASS_BASIC, 8, 0), (Object[])new Object[]{"XXX", "XWX", "XXX", Character.valueOf('W'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('X'), Blocks.field_150359_w});
        for (int var2 = 0; var2 < 16; ++var2) {
            RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FUTURE_GLASS_COLORED, 8, var2), (Object[])new Object[]{"XXX", "XWX", "XXX", Character.valueOf('X'), new ItemStack(GSBlocks.FUTURE_GLASS_BASIC, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151100_aR, 1, var2)});
        }
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.SOLARWIND_PANEL, 1, 0), (Object[])new Object[]{"XYX", "XZX", "VWV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('W'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 2), Character.valueOf('Z'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FUEL_GENERATOR, 1, 0), (Object[])new Object[]{"WYW", "WZW", "XXX", Character.valueOf('W'), new ItemStack(GCItems.canister, 1, 1), Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(Blocks.field_150410_aZ, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ASSEMBLER, 1, 0), (Object[])new Object[]{"VWV", "XYX", "ZWC", Character.valueOf('V'), "plateSteel", Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 13), Character.valueOf('Y'), new ItemStack(Blocks.field_150462_ai, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase, 1, 12), Character.valueOf('C'), new ItemStack(GCBlocks.machineBase2, 1, 4)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ROCKET_ASSEMBLER, 1, 0), (Object[])new Object[]{"VWV", "XYZ", "BNB", Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 14), Character.valueOf('W'), new ItemStack(GCBlocks.nasaWorkbench, 1, 0), Character.valueOf('X'), new ItemStack(GCBlocks.machineBase2, 1, 0), Character.valueOf('Y'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase2, 1, 4), Character.valueOf('B'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('N'), new ItemStack(GSBlocks.ASSEMBLER)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 13), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(Blocks.field_150451_bX, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 1), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), plateTitanium, Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 14), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), "plateMagnesium", Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MODERN_STORAGE_MODULE, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), new ItemStack(GSItems.INGOTS, 1, 1), Character.valueOf('Y'), new ItemStack(GCBlocks.machineTiered, 1, 8), Character.valueOf('W'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.OXYGEN_STORAGE_MODULE, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XZX", Character.valueOf('X'), new ItemStack(GCBlocks.machineBase2, 1, 8), Character.valueOf('Y'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('W'), new ItemStack(GCBlocks.oxygenPipe, 1, 0), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 1), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 5)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MODERN_SOLAR_PANEL, 1, 0), (Object[])new Object[]{"XYX", "WVW", "CZC", Character.valueOf('X'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 1), Character.valueOf('W'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2), Character.valueOf('Z'), new ItemStack(GCBlocks.solarPanel, 1, 4), Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.GRAVITATION_MODULE, 1, 0), (Object[])new Object[]{"XYX", "WVW", "CZC", Character.valueOf('X'), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 8), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('V'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('Z'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2), Character.valueOf('C'), new ItemStack(GCItems.basicItem, 1, 14)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.WIND_GENERATOR, 1, 0), (Object[])new Object[]{"XYX", "MVM", "CZC", Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 5), Character.valueOf('Y'), new ItemStack(GCItems.oxygenFan, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('M'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('Z'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('C'), "compressedMeteoricIron"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.UNIVERSAL_RECYCLER, 1, 0), (Object[])new Object[]{"XYX", "MZM", "CVC", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), new ItemStack(GCBlocks.fluidTank, 1, 0), Character.valueOf('V'), new ItemStack(GCBlocks.machineTiered, 1, 4), Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Z'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('M'), new ItemStack(GSItems.BASIC, 1, 5)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.LIQUID_EXTRACTOR, 1, 0), (Object[])new Object[]{"XZX", "MCM", "VBV", Character.valueOf('X'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('Z'), new ItemStack(GCBlocks.fluidTank, 1, 0), Character.valueOf('M'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('V'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('B'), new ItemStack(GCBlocks.oxygenPipe, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.LIQUID_SEPARATOR, 1, 0), (Object[])new Object[]{"XZX", "ZCZ", "VBV", Character.valueOf('X'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('Z'), new ItemStack(GCBlocks.fluidTank, 1, 0), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('V'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('B'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.HYDROPONIC_BASE, 1, 0), (Object[])new Object[]{"ABC", "DED", "DFD", Character.valueOf('A'), new ItemStack(GCItems.basicItem, 1, 20), Character.valueOf('B'), new ItemStack(GCBlocks.fluidTank, 1, 0), Character.valueOf('C'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('D'), plateSteel, Character.valueOf('E'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('F'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.HYDROPONIC_FARM, 1, 0), (Object[])new Object[]{"XXX", "XCX", "VBV", Character.valueOf('X'), new ItemStack(Blocks.field_150359_w, 1, 0), Character.valueOf('B'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('C'), "dirt", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.RADIATION_STABILISER, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "XBX", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 3), Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GCBlocks.basicBlock, 1, 9)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.PANEL_CONTROLLER, 1, 0), (Object[])new Object[]{"XXX", "ZCV", "NBN", Character.valueOf('X'), plateTitanium, Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 3), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2), Character.valueOf('N'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('V'), new ItemStack(GCBlocks.screen, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MODIFICATION_TABLE, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "VBV", Character.valueOf('V'), plateBronze, Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 14), Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('Z'), new ItemStack(Items.field_151137_ax, 1, 0), Character.valueOf('Y'), "plateCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.GAS_BURNER, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "VBV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('X'), new ItemStack(GCBlocks.fluidTank, 1, 0), Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 0), Character.valueOf('Z'), new ItemStack(Items.field_151033_d, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.oxygenVent, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ADVANCED_CIRCUIT_FABRICATOR, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "XBX", Character.valueOf('X'), plateDesh, Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 1), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 3), Character.valueOf('Y'), new ItemStack(GCBlocks.machineBase2, 1, 4)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ADVANCED_ELECTRIC_COMPRESSOR, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "XBX", Character.valueOf('X'), plateDesh, Character.valueOf('B'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 1), Character.valueOf('Z'), new ItemStack(MarsItems.marsItemBasic, 1, 1), Character.valueOf('Y'), new ItemStack(GCBlocks.machineBase2, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.PLANET_SHIELD, 1, 0), (Object[])new Object[]{"XYX", "VCV", "ZZZ", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('X'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('C'), new ItemStack(GSBlocks.MACHINE_FRAMES, 1, 2), Character.valueOf('Z'), new ItemStack(GSItems.HDP, 1, 0), Character.valueOf('Y'), new ItemStack(GSBlocks.GRAVITATION_MODULE, 1, 0)});
    }

    private static void addItemRecipes() {
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_HELMET, 1), (Object[])new Object[]{"XXX", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_CHEST, 1), (Object[])new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_LEGS, 1), (Object[])new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_BOOTS, 1), (Object[])new Object[]{"X X", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_SWORD, 1), (Object[])new Object[]{" X ", " X ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_AXE, 1), (Object[])new Object[]{"XX ", "XY ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_PICKAXE, 1), (Object[])new Object[]{"XXX", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_SPADE, 1), (Object[])new Object[]{" X ", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.COBALT_HOE, 1), (Object[])new Object[]{"XX ", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 3, 9), (Object[])new Object[]{"XXX", "CYC", "XXX", Character.valueOf('X'), plateIron, Character.valueOf('C'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Y'), Items.field_151117_aB});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.JETPACK, 1, GSItems.JETPACK.func_77612_l()), (Object[])new Object[]{"ABA", "CDC", "EFE", Character.valueOf('A'), GCBlocks.oxygenPipe, Character.valueOf('B'), new ItemStack(GCItems.battery, 1, Short.MAX_VALUE), Character.valueOf('C'), plateSteel, Character.valueOf('D'), GCItems.steelChestplate, Character.valueOf('E'), new ItemStack(GCItems.fuelCanister, 1, 1), Character.valueOf('F'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 0), (Object[])new Object[]{"XXX", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 21)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 1), (Object[])new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 21)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 2), (Object[])new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 21)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 3), (Object[])new Object[]{"X X", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 21)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 0), (Object[])new Object[]{"XXX", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 22)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 1), (Object[])new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 22)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 2), (Object[])new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 22)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 3), (Object[])new Object[]{"X X", "X X", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 22)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ADVANCED_BATTERY, 1, GSItems.ADVANCED_BATTERY.func_77612_l()), (Object[])new Object[]{" T ", "TRT", "TCT", Character.valueOf('T'), "plateNickel", Character.valueOf('R'), new ItemStack(GCItems.battery, 1, GCItems.battery.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.MODERN_BATTERY, 1, GSItems.MODERN_BATTERY.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), plateTitanium, Character.valueOf('R'), new ItemStack(GSItems.ADVANCED_BATTERY, 1, GSItems.ADVANCED_BATTERY.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 7)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.EXTRA_BATTERY, 1, GSItems.EXTRA_BATTERY.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), new ItemStack(GSItems.HDP, 1, 0), Character.valueOf('R'), new ItemStack(GSItems.MODERN_BATTERY, 1, GSItems.MODERN_BATTERY.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 7)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ULTIMATE_BATTERY, 1, GSItems.ULTIMATE_BATTERY.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), new ItemStack(GSItems.HDP, 1, 0), Character.valueOf('R'), new ItemStack(GSItems.EXTRA_BATTERY, 1, GSItems.EXTRA_BATTERY.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 8)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 1, 1), (Object[])new Object[]{"X  ", "YX ", "VZX", Character.valueOf('Y'), plateSteel, Character.valueOf('X'), GCItems.flagPole, Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 0), Character.valueOf('Z'), plateIron});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 1, 2), (Object[])new Object[]{"YXY", "XYX", "YXY", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 1), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 0), (Object[])new Object[]{"ZXX", "XYV", "BNB", Character.valueOf('Z'), new ItemStack(GCItems.basicItem, 1, 19), Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 9), Character.valueOf('Y'), new ItemStack(GCItems.partBuggy, 1, 1), Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 6), Character.valueOf('B'), GCItems.flagPole, Character.valueOf('N'), new ItemStack(GCItems.rocketEngine, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 1), (Object[])new Object[]{"ZXZ", "YVY", "ZYZ", Character.valueOf('Z'), new ItemStack(Items.field_151007_F, 1, 0), Character.valueOf('X'), new ItemStack(GCItems.parachute, 1, Short.MAX_VALUE), Character.valueOf('Y'), GCItems.canvas, Character.valueOf('V'), new ItemStack(GSItems.ROCKET_MODULES, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 2), (Object[])new Object[]{"ZXZ", "YWY", "ZZZ", Character.valueOf('Z'), plateSteel, Character.valueOf('X'), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('W'), new ItemStack(GCItems.partBuggy, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OXYGENTANK_TIER_4, 1, GSItems.OXYGENTANK_TIER_4.func_77612_l()), (Object[])new Object[]{"XYX", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(Blocks.field_150325_L, 1, 11), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GCItems.oxTankHeavy, 1, GCItems.oxTankHeavy.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OXYGENTANK_TIER_5, 1, GSItems.OXYGENTANK_TIER_5.func_77612_l()), (Object[])new Object[]{"XYX", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GSItems.OXYGENTANK_TIER_4, 1, GSItems.OXYGENTANK_TIER_4.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OXYGENTANK_TIER_6, 1, GSItems.OXYGENTANK_TIER_6.func_77612_l()), (Object[])new Object[]{"XYA", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(GCItems.oxygenVent, 1, 0), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GSItems.OXYGENTANK_TIER_5, 1, GSItems.OXYGENTANK_TIER_5.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6), Character.valueOf('A'), GCItems.oxygenConcentrator});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 1, 11), (Object[])new Object[]{"XYX", "CZC", "XBX", Character.valueOf('X'), plateTin, Character.valueOf('Y'), Items.field_151043_k, Character.valueOf('Z'), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 1), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack(GCItems.basicItem, 1, 13)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.UPGRADES, 1, 0), (Object[])new Object[]{" Z ", "XYX", "BCB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 11), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 3), Character.valueOf('C'), new ItemStack(GSItems.BASIC, 1, 12), Character.valueOf('B'), new ItemStack(GSItems.INGOTS, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.UPGRADES, 1, 1), (Object[])new Object[]{" Z ", "XYX", "BCB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 11), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 3), Character.valueOf('C'), new ItemStack(GSItems.BASIC, 1, 8), Character.valueOf('B'), new ItemStack(GSItems.INGOTS, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.UPGRADES, 1, 2), (Object[])new Object[]{" Z ", "XYX", "BCB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 11), Character.valueOf('Z'), new ItemStack(AsteroidsItems.canisterLN2, 1, 1), Character.valueOf('C'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('B'), new ItemStack(GSItems.INGOTS, 1, 2)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.UPGRADES, 1, 3), (Object[])new Object[]{" Z ", "XYX", "BCB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 11), Character.valueOf('Z'), new ItemStack(VenusItems.basicItem, 1, 4), Character.valueOf('C'), new ItemStack(GSItems.BASIC, 1, 5), Character.valueOf('B'), new ItemStack(GSItems.INGOTS, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 1, 21), (Object[])new Object[]{"XZX", "CYC", "XZX", Character.valueOf('X'), new ItemStack(GSItems.BASIC, 1, 4), Character.valueOf('Y'), new ItemStack(AsteroidsItems.canisterLN2, 1, 1), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 12), Character.valueOf('C'), new ItemStack(VenusItems.basicItem, 1, 3)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BASIC, 1, 22), (Object[])new Object[]{"XZX", "CYC", "XZX", Character.valueOf('X'), new ItemStack(VenusItems.basicItem, 1, 4), Character.valueOf('Y'), new ItemStack(GSItems.BASIC, 1, 17), Character.valueOf('Z'), new ItemStack(GSItems.BASIC, 1, 8), Character.valueOf('C'), new ItemStack(GSItems.BASIC, 1, 21)});
        RecipeUtil.addCustomRecipe((IRecipe)new ShapedRecipeNBT(new ItemStack(GSItems.BASIC, 1, 20), ItemBasicGS.getRecipe()));
    }

    private static void addBlockSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 0), (ItemStack)new ItemStack(GSItems.INGOTS, 1, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 1), (ItemStack)new ItemStack(GSItems.INGOTS, 1, 2), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSItems.BASIC, 1, 17), (ItemStack)new ItemStack(Items.field_151131_as), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSItems.BASIC, 1, 6), (ItemStack)new ItemStack(Items.field_151042_j, 2), (float)1.0f);
    }

    private static void addCompressor() {
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.COMPRESSED_PLATES, 1, 0), (Object[])new Object[]{Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GCItems.itemBasicMoon, 1, 0), (Object[])new Object[]{new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13), new ItemStack(GSItems.BASIC, 1, 13)});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.COMPRESSED_PLATES, 1, 0), (Object[])new Object[]{Blocks.field_150402_ci});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.COMPRESSED_PLATES, 1, 1), (Object[])new Object[]{"ingotCobalt", "ingotCobalt"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.COMPRESSED_PLATES, 1, 2), (Object[])new Object[]{"ingotMagnesium", "ingotMagnesium"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.COMPRESSED_PLATES, 1, 3), (Object[])new Object[]{"ingotNickel", "ingotNickel"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151044_h), (Object[])new Object[]{MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments, MarsItems.carbonFragments});
    }

    private static void addCircuitFabricator() {
        ItemStack modernWafers = new ItemStack(GSItems.BASIC, 1, 5);
        CircuitFabricatorRecipes.addRecipe((ItemStack)modernWafers, Arrays.asList(new ItemStack(Items.field_151045_i), new ItemStack(GCItems.itemBasicMoon, 1, 2), new ItemStack(GCItems.itemBasicMoon, 1, 2), new ItemStack(Items.field_151137_ax), new ItemStack(GCItems.basicItem, 1, 14)));
    }

    private static void addAssembly() {
        if (GSConfigSchematics.enableDuplicateSchematic) {
            AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.BASIC, 1, 14), "compressedMeteoricIron", new ItemStack(Items.field_151100_aR, 1, 0), "compressedMeteoricIron", new ItemStack(Items.field_151100_aR, 1, 5), new ItemStack(Items.field_151121_aF, 1, 0), new ItemStack(Items.field_151100_aR, 1, 5), "compressedMeteoricIron", new ItemStack(Items.field_151100_aR, 1, 0), "compressedMeteoricIron");
            for (int i = 0; i < 6; ++i) {
                AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.SCHEMATICS, 2, i), new ItemStack(GSItems.BASIC, 1, 14), new ItemStack(GSItems.SCHEMATICS, 1, i));
            }
        }
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GCItems.schematic, 2, 0), new ItemStack(GSItems.BASIC, 1, 14), new ItemStack(GCItems.schematic, 1, 0));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GCItems.schematic, 2, 1), new ItemStack(GSItems.BASIC, 1, 14), new ItemStack(GCItems.schematic, 1, 1));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateBronze, "plateCoal", plateAluminum);
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.BASIC, 1, 0), plateSteel, plateSteel, plateSteel, plateSteel, Blocks.field_150410_aZ, plateSteel, plateSteel, plateSteel, plateSteel);
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.ROCKET_MODULES, 1, 3), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GSItems.BASIC, 1, 0), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.SPACE_SUIT_HELMET, 1), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, new ItemStack((Block)Blocks.field_150397_co, 1, 1), plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), GCItems.oxygenConcentrator, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.SPACE_SUIT_BODY, 1), plateSteel, "ingotNickel", plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GCItems.steelChestplate, 1, 0), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel);
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.SPACE_SUIT_LEGGINS, 1), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, "ingotNickel", plateSteel, plateSteel, "ingotNickel", plateSteel);
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.SPACE_SUIT_BOOTS, 1), plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, plateSteel, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), plateSteel, "ingotNickel", new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), "ingotNickel");
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.HDP, 1, 0), "plateMagnesium", new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(AsteroidsItems.basicItem, 1, 5));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.HDP, 1, 1), "plateCobalt", new ItemStack(GSItems.HDP, 1, 0), "plateNickel", new ItemStack(GSItems.BASIC, 1, 4));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSItems.HDP, 1, 2), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GSItems.HDP, 1, 1), new ItemStack(GSItems.BASIC, 1, 12));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSBlocks.SINGLE_SOLARPANEL, 1, 0), "blockGlass", "blockGlass", "blockGlass", new ItemStack(GCItems.basicItem, 1, 0), new ItemStack(GCItems.basicItem, 1, 0), new ItemStack(GCItems.basicItem, 1, 0), new ItemStack(MarsItems.marsItemBasic, 1, 5), new ItemStack(GSItems.BASIC, 1, 5), new ItemStack(MarsItems.marsItemBasic, 1, 5));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSBlocks.MODERN_SINGLE_SOLARPANEL, 1, 0), new ItemStack(GSItems.BASIC, 1, 4), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack(GSItems.BASIC, 1, 4), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 1), new ItemStack(GSBlocks.SINGLE_SOLARPANEL, 1, 0), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 1));
        AssemblyRecipes.addShapelessRecipe(new ItemStack(GSBlocks.ADVANCED_LANDING_PAD_SINGLE, 5, 0), plateTitanium, plateTitanium, plateTitanium, new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GSItems.COMPRESSED_PLATES, 1, 4), new ItemStack(GCBlocks.basicBlock, 1, 12), new ItemStack(GCBlocks.basicBlock, 1, 12), new ItemStack(GCBlocks.basicBlock, 1, 12));
    }

    private static void addRocketAssembly() {
        if (GSConfigCore.enableAdvancedRocketCraft) {
            CraftingRecipesOverworld.addRocketRecipe(AsteroidsItems.tier3Rocket, GSItems.ROCKET_PARTS, 0);
        }
        CraftingRecipesOverworld.addRocketRecipe(GSItems.ROCKET_TIER_4, GSItems.ROCKET_PARTS, 5);
        CraftingRecipesOverworld.addRocketRecipe(GSItems.ROCKET_TIER_5, GSItems.ROCKET_PARTS, 10);
        CraftingRecipesOverworld.addRocketRecipe(GSItems.ROCKET_TIER_6, GSItems.ROCKET_PARTS, 15);
    }

    private static void addRecycler() {
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 3), new ItemStack(GSItems.BASIC, 6, 4), null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(Blocks.field_150403_cj, 1), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 500));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GCBlocks.blockMoon, 1, 4), new ItemStack(GCItems.itemBasicMoon, 1, 2), 5, null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GCBlocks.blockMoon, 1, 5), new ItemStack(GCBlocks.blockMoon, 1, 3), new FluidStack(GSFluids.Helium3, 10));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(MarsBlocks.marsBlock, 20, 5), new ItemStack(GSItems.BASIC, 1, 6), null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 7), new ItemStack(Items.field_151016_H, 1, 0), new FluidStack(VenusModule.sulphuricAcid, 20));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.SURFACE_ICE, 1), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 100));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.EUROPA_BLOCKS, 1, 2), new ItemStack(GSItems.BASIC, 1, 6), 50, new FluidStack(FluidRegistry.WATER, 100));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.MERCURY_BLOCKS, 1, 0), ItemStack.field_190927_a, new FluidStack(GSFluids.Helium3, 100));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.MERCURY_BLOCKS, 1, 2), new ItemStack(GSItems.BASIC, 1, 7), 35, null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(VenusBlocks.venusBlock, 20, 0), new ItemStack(VenusBlocks.venusBlock, 1, 8), 50, null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 23), ItemStack.field_190927_a, FluidRegistry.getFluidStack((String)"oxygen", (int)25));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 24), ItemStack.field_190927_a, FluidRegistry.getFluidStack((String)"nitrogen", (int)20));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 25), ItemStack.field_190927_a, FluidRegistry.getFluidStack((String)"methane", (int)20));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 26), ItemStack.field_190927_a, FluidRegistry.getFluidStack((String)"hydrogen", (int)20));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BASIC, 1, 27), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 50));
    }

    private static void addOtherRecipes() {
        TileEntityLiquidExtractor.addBlockAndFluid(Blocks.field_150403_cj, new FluidStack(FluidRegistry.WATER, 50));
        TileEntityLiquidExtractor.addBlockAndFluid(AsteroidBlocks.blockDenseIce, new FluidStack(FluidRegistry.WATER, 100));
        TileEntityLiquidExtractor.addBlockAndFluid(GSBlocks.SURFACE_ICE, new FluidStack(FluidRegistry.WATER, 100));
        TileEntityLiquidExtractor.addBlockAndFluid(GSBlocks.MIRANDA_BLOCKS.func_176223_P().func_177226_a(MirandaBlocks.BASIC_TYPE, (Comparable)((Object)MirandaBlocks.EnumMirandaBlocks.MIRANDA_ICE)).func_177230_c(), new FluidStack(FluidRegistry.WATER, 100));
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), 100, Blocks.field_150464_aj, 7, new boolean[]{false, true});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF), ItemStack.field_190927_a, 100, Blocks.field_150459_bM, 3, new boolean[]{true, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151170_bI), 2, Blocks.field_150469_bN, 3, new boolean[]{true, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150440_ba), ItemStack.field_190927_a, 100, Blocks.field_150394_bc, 1, new boolean[]{false, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150423_aK), ItemStack.field_190927_a, 100, Blocks.field_150393_bb, 3, new boolean[]{false, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_185164_cV), new ItemStack(Items.field_185163_cU), 100, Blocks.field_185773_cZ, 3, new boolean[]{false, true});
        TileEntityFuelGenerator.registerNewFuel(FluidRegistry.LAVA, 5, 0.6f);
        FluidRegistry.getRegisteredFluids().forEach((name, fluid) -> {
            if (name.contains("fuel")) {
                TileEntityFuelGenerator.registerNewFuel(fluid, 20, 1.5f);
            }
            if (name.contains("oil")) {
                TileEntityFuelGenerator.registerNewFuel(fluid, 10, 1.0f);
            }
        });
        TileEntityFuelGenerator.registerNewFuel(GSFluids.LiquidEthaneMethane, 20, 1.3f);
        TileEntityFuelGenerator.registerNewFuel(AsteroidsModule.fluidLiquidMethane, 50, 1.4f);
        TileEntityFuelGenerator.registerNewFuel(GSFluids.HeliumHydrogen, 50, 2.0f);
        TileEntityDeconstructor.knownRecipes.addAll(GSRecipeUtil.getBodyRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(GSRecipeUtil.getBoosterRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(GSRecipeUtil.getConeRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(GSRecipeUtil.getEngineRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(GSRecipeUtil.getFinsRecipes());
        for (int i = 1; i < 3; ++i) {
            LinkedList<NasaWorkbenchRecipe> knownRecipes = new LinkedList<NasaWorkbenchRecipe>();
            HashMap<Integer, ItemStack> input = new HashMap<Integer, ItemStack>();
            input.put(0, new ItemStack(GSItems.ROCKET_PARTS, 1, 5 * i));
            input.put(1, new ItemStack(GSItems.ROCKET_PARTS, 1, 6 * i));
            input.put(2, new ItemStack(GSItems.ROCKET_PARTS, 1, 7 * i));
            input.put(3, new ItemStack(GSItems.ROCKET_PARTS, 1, 8 * i));
            input.put(4, new ItemStack(GSItems.ROCKET_PARTS, 1, 9 * i));
            Item rocket = GSItems.ROCKET_TIER_4;
            if (i == 2) {
                rocket = GSItems.ROCKET_TIER_5;
            }
            if (i == 3) {
                rocket = GSItems.ROCKET_TIER_6;
            }
            for (int k = 0; k < 3; ++k) {
                knownRecipes.add(new NasaWorkbenchRecipe(new ItemStack(rocket, 1, k), input));
            }
            TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.ROCKET_PARTS, 1, 5 * i));
            TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.ROCKET_PARTS, 1, 6 * i));
            TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.ROCKET_PARTS, 1, 7 * i));
            TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.ROCKET_PARTS, 1, 8 * i));
            TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.ROCKET_PARTS, 1, 9 * i));
            TileEntityDeconstructor.knownRecipes.addAll(knownRecipes);
        }
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.HDP, 1, 0));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.HDP, 1, 1));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(GSItems.HDP, 1, 2));
    }

    private static void addRocketRecipe(Item rocket, Item parts, int metafirstparts) {
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 0), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 1), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 2), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 3), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
    }
}

