/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.commands;

import com.google.common.collect.Lists;
import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.commands.AbstractCommand;
import io.github.aquerr.chestrefill.entities.Kit;
import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class KitsCommand
extends AbstractCommand
implements CommandExecutor {
    public KitsCommand(ChestRefill plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        ArrayList helpList = Lists.newArrayList();
        for (Kit kit : super.getPlugin().getContainerManager().getKits().values()) {
            Text.Builder itemsToShow = Text.builder();
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Kit's name: ", TextColors.YELLOW, kit.getName() + "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Items in kit: \n"})});
            kit.getItems().forEach(x -> itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, x.getItem().getTranslation().get(), TextColors.RESET, " x" + x.getItem().getQuantity() + "\n"})}));
            Text kitText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - ", TextColors.YELLOW, kit.getName()})}).onHover((HoverAction)TextActions.showText((Text)itemsToShow.build())).build();
            helpList.add(kitText);
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, "List of Kits"})).padding(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "-"})).contents((Iterable)helpList).linesPerPage(10);
        paginationBuilder.sendTo((MessageReceiver)source);
        return CommandResult.success();
    }
}

