/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.commands;

import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.PluginInfo;
import io.github.aquerr.chestrefill.commands.AbstractCommand;
import io.github.aquerr.chestrefill.entities.Kit;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class RemoveKitCommand
extends AbstractCommand
implements CommandExecutor {
    public RemoveKitCommand(ChestRefill plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalName = context.getOne((Text)Text.of((String)"kit name"));
        if (!optionalName.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.RED, "You must specify a kit name!"}));
            return CommandResult.empty();
        }
        Map<String, Kit> kits = super.getPlugin().getContainerManager().getKits();
        if (!kits.keySet().stream().anyMatch(x -> x.equals(optionalName.get()))) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.RED, "Kit with given name does not exists!"}));
            return CommandResult.empty();
        }
        boolean didSucceed = super.getPlugin().getContainerManager().removeKit((String)optionalName.get());
        if (didSucceed) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.GREEN, "Successfully removed the kit!"}));
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.RED, "Something went wrong..."}));
        }
        return CommandResult.success();
    }
}

