/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.managers;

import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.entities.ContainerLocation;
import io.github.aquerr.chestrefill.entities.Kit;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.entities.RefillableItem;
import io.github.aquerr.chestrefill.scheduling.ScanForEmptyContainersTask;
import io.github.aquerr.chestrefill.storage.StorageHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

public class ContainerManager {
    private ChestRefill plugin;
    private StorageHelper storageHelper;

    public ContainerManager(ChestRefill plugin, Path configDir) {
        this.plugin = plugin;
        if (!Files.isDirectory(configDir, new LinkOption[0])) {
            try {
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.storageHelper = new StorageHelper(configDir);
    }

    public boolean addRefillableContainer(RefillableContainer refillableContainer) {
        if (this.storageHelper.addOrUpdateContainer(refillableContainer)) {
            return this.startRefillingContainer(refillableContainer.getContainerLocation(), refillableContainer.getRestoreTime());
        }
        return false;
    }

    public boolean updateRefillableContainer(RefillableContainer refillableContainer) {
        return this.storageHelper.addOrUpdateContainer(refillableContainer);
    }

    public Collection<RefillableContainer> getRefillableContainers() {
        return this.storageHelper.getRefillableContainers();
    }

    public Set<ContainerLocation> getContainerLocations() {
        return this.storageHelper.getContainerLocations();
    }

    public boolean removeRefillableContainer(ContainerLocation containerLocation) {
        boolean successfullyStopped = this.stopRefillingContainer(containerLocation);
        boolean successfullyRemoved = this.storageHelper.removeContainer(containerLocation);
        return successfullyStopped && successfullyRemoved;
    }

    private boolean stopRefillingContainer(ContainerLocation containerLocation) {
        try {
            this.plugin.getContainerScheduler().cancelTask("Chest Refill " + containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID().toString());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Nullable
    private RefillableContainer getRefillableContainer(ContainerLocation containerLocation) {
        return this.storageHelper.getRefillableContainer(containerLocation);
    }

    private boolean startRefillingContainer(ContainerLocation containerLocation, int time) {
        try {
            String name = "Chest Refill " + containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID().toString();
            this.plugin.getContainerScheduler().scheduleWithInterval(name, time, TimeUnit.SECONDS, this.runRefillContainer(containerLocation));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean refillContainer(ContainerLocation containerLocation) {
        RefillableContainer chestToRefill;
        block19: {
            chestToRefill = this.getRefillableContainer(containerLocation);
            try {
                Optional world = Sponge.getServer().getWorld(chestToRefill.getContainerLocation().getWorldUUID());
                if (!world.isPresent()) break block19;
                RefillableContainer refillableContainer = chestToRefill;
                synchronized (refillableContainer) {
                    Optional optionalTileEntity;
                    Location location = new Location((Extent)world.get(), chestToRefill.getContainerLocation().getBlockPosition());
                    if (!location.getTileEntity().isPresent() && chestToRefill.shouldBeHiddenIfNoItems()) {
                        location.setBlockType(chestToRefill.getContainerBlockType());
                    }
                    if ((optionalTileEntity = location.getTileEntity()).isPresent()) {
                        TileEntityCarrier chest = (TileEntityCarrier)location.getTileEntity().get();
                        if (chestToRefill.shouldReplaceExistingItems()) {
                            chest.getInventory().clear();
                        }
                        ArrayList<RefillableItem> itemsAchievedFromRandomizer = new ArrayList<RefillableItem>();
                        List<RefillableItem> refillableItems = chestToRefill.getKitName().equals("") ? chestToRefill.getItems() : this.getKit(chestToRefill.getKitName()).getItems();
                        for (RefillableItem refillableItem : refillableItems) {
                            double number = Math.random();
                            if (!(number <= (double)refillableItem.getChance())) continue;
                            itemsAchievedFromRandomizer.add(refillableItem);
                        }
                        if (chestToRefill.isOneItemAtTime()) {
                            if (itemsAchievedFromRandomizer.size() > 0) {
                                RefillableItem lowestChanceItem = (RefillableItem)itemsAchievedFromRandomizer.get(0);
                                for (RefillableItem item : itemsAchievedFromRandomizer) {
                                    if (!(item.getChance() < lowestChanceItem.getChance())) continue;
                                    lowestChanceItem = item;
                                }
                                boolean bl = false;
                                for (Inventory slot : chest.getInventory().slots()) {
                                    void var11_15;
                                    if (lowestChanceItem.getSlot() == var11_15) {
                                        slot.offer(ItemStack.builder().fromItemStack(lowestChanceItem.getItem()).build());
                                        break;
                                    }
                                    ++var11_15;
                                }
                            }
                        } else {
                            for (RefillableItem refillableItem : itemsAchievedFromRandomizer) {
                                int i = 0;
                                for (Inventory slot : chest.getInventory().slots()) {
                                    if (refillableItem.getSlot() == i) {
                                        slot.offer(ItemStack.builder().fromItemStack(refillableItem.getItem()).build());
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (chestToRefill.shouldBeHiddenIfNoItems() && chest.getInventory().totalItems() == 0) {
                            location.setBlockType(chestToRefill.getHidingBlock());
                        }
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.plugin.getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Couldn't refill : " + chestToRefill.getName()}));
        this.plugin.getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Container block type : " + chestToRefill.getContainerBlockType()}));
        this.plugin.getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Container block position : " + chestToRefill.getContainerLocation().getBlockPosition() + "|" + chestToRefill.getContainerLocation().getWorldUUID().toString()}));
        this.plugin.getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Container items : " + chestToRefill.getItems()}));
        this.plugin.getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Suggestion: Remove this container from the containers.json file and restart server."}));
        return false;
    }

    public Runnable runRefillContainer(ContainerLocation containerLocation) {
        return () -> this.refillContainer(containerLocation);
    }

    public void restoreRefilling() {
        for (RefillableContainer refillableContainer : this.getRefillableContainers()) {
            this.startRefillingContainer(refillableContainer.getContainerLocation(), refillableContainer.getRestoreTime());
        }
    }

    public boolean updateRefillingTime(ContainerLocation containerLocation, int time) {
        return this.stopRefillingContainer(containerLocation) && this.storageHelper.updateContainerTime(containerLocation, time) && this.startRefillingContainer(containerLocation, time);
    }

    public boolean renameRefillableContainer(ContainerLocation containerLocation, String containerName) {
        return this.storageHelper.changeContainerName(containerLocation, containerName);
    }

    public Map<String, Kit> getKits() {
        return this.storageHelper.getKits();
    }

    public boolean createKit(Kit kit) {
        return this.storageHelper.createKit(kit);
    }

    public boolean removeKit(String kitName) {
        return this.storageHelper.removeKit(kitName);
    }

    public boolean assignKit(ContainerLocation containerLocation, String kitName) {
        RefillableContainer refillableContainer = this.getRefillableContainer(containerLocation);
        refillableContainer.setKit(kitName);
        return this.storageHelper.assignKit(containerLocation, kitName);
    }

    public Optional<RefillableContainer> getRefillableContainerAtLocation(ContainerLocation containerLocation) {
        RefillableContainer refillableContainer = this.storageHelper.getRefillableContainer(containerLocation);
        if (refillableContainer == null) {
            return Optional.empty();
        }
        return Optional.of(refillableContainer);
    }

    public void startLookingForEmptyContainers() {
        this.plugin.getContainerScheduler().scheduleWithInterval("Chest Refill - Scanning for empty containers", 5L, TimeUnit.SECONDS, new ScanForEmptyContainersTask(this));
    }

    public Kit getKit(String name) {
        return this.getKits().get(name);
    }
}

