/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.storage;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.PluginInfo;
import io.github.aquerr.chestrefill.entities.ContainerLocation;
import io.github.aquerr.chestrefill.entities.Kit;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.entities.RefillableItem;
import io.github.aquerr.chestrefill.storage.Storage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class JSONStorage
implements Storage {
    private Path containersPath;
    private GsonConfigurationLoader containersLoader;
    private ConfigurationNode containersNode;
    private Path kitsPath;
    private GsonConfigurationLoader kitsLoader;
    private ConfigurationNode kitsNode;
    private WatchService _watchService;
    private WatchKey _key;

    public JSONStorage(Path configDir) {
        try {
            this.containersPath = Paths.get(configDir + "/containers.json", new String[0]);
            this.kitsPath = Paths.get(configDir + "/kits.json", new String[0]);
            if (!Files.exists(this.containersPath, new LinkOption[0])) {
                Files.createFile(this.containersPath, new FileAttribute[0]);
            }
            if (!Files.exists(this.kitsPath, new LinkOption[0])) {
                Files.createFile(this.kitsPath, new FileAttribute[0]);
            }
            this.containersLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setPath(this.containersPath)).build();
            this.containersNode = this.containersLoader.load();
            this.kitsLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setPath(this.kitsPath)).build();
            this.kitsNode = this.kitsLoader.load();
            this._watchService = configDir.getFileSystem().newWatchService();
            this._key = configDir.register(this._watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Task.Builder changeTask = Sponge.getScheduler().createTaskBuilder();
            changeTask.async().intervalTicks(50L).execute(this.checkFileUpdate()).submit((Object)ChestRefill.getInstance());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addOrUpdateContainer(RefillableContainer refillableContainer) {
        try {
            String blockPositionAndWorldUUID = refillableContainer.getContainerLocation().getBlockPosition().toString() + "|" + refillableContainer.getContainerLocation().getWorldUUID();
            ArrayList<RefillableItem> items = new ArrayList<RefillableItem>(refillableContainer.getItems());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "name"}).setValue((Object)refillableContainer.getName());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "container-block-type"}).setValue(TypeToken.of(BlockType.class), (Object)refillableContainer.getContainerBlockType());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "kit"}).setValue((Object)refillableContainer.getKitName());
            if (refillableContainer.getKitName().equals("")) {
                this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "items"}).setValue((TypeToken)new TypeToken<List<RefillableItem>>(){}, items);
            } else {
                this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "items"}).setValue(new ArrayList());
            }
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "time"}).setValue((Object)refillableContainer.getRestoreTime());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "one-item-at-time"}).setValue((Object)refillableContainer.isOneItemAtTime());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "replace-existing-items"}).setValue((Object)refillableContainer.shouldReplaceExistingItems());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "hidden-if-no-items"}).setValue((Object)refillableContainer.shouldBeHiddenIfNoItems());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "hiding-block"}).setValue(TypeToken.of(BlockType.class), (Object)refillableContainer.getHidingBlock());
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "required-permission"}).setValue((Object)refillableContainer.getRequiredPermission());
            this.containersLoader.save(this.containersNode);
            return true;
        }
        catch (IOException | ObjectMappingException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeRefillableContainer(ContainerLocation containerLocation) {
        try {
            String blockPositionAndWorldUUID = containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID();
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers"}).removeChild((Object)blockPositionAndWorldUUID);
            this.containersLoader.save(this.containersNode);
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public List<ContainerLocation> getContainerLocations() {
        Set objectList = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers"}).getChildrenMap().keySet();
        ArrayList<ContainerLocation> containerLocations = new ArrayList<ContainerLocation>();
        for (Object object : objectList) {
            String chestPositionAndWorldUUIDString = (String)object;
            String splitter = "\\|";
            String[] chestPosAndWorldUUID = chestPositionAndWorldUUIDString.split(splitter);
            UUID worldUUID = UUID.fromString(chestPosAndWorldUUID[1]);
            String[] vectors = chestPosAndWorldUUID[0].replace("(", "").replace(")", "").replace(" ", "").split(",");
            int x = Integer.valueOf(vectors[0]);
            int y = Integer.valueOf(vectors[1]);
            int z = Integer.valueOf(vectors[2]);
            ContainerLocation containerLocation = new ContainerLocation(Vector3i.from((int)x, (int)y, (int)z), worldUUID);
            containerLocations.add(containerLocation);
        }
        return containerLocations;
    }

    @Override
    public List<RefillableContainer> getRefillableContainers() {
        ArrayList<RefillableContainer> refillingContainersList = new ArrayList<RefillableContainer>();
        for (ContainerLocation containerLocation : this.getContainerLocations()) {
            RefillableContainer refillableContainer = this.getRefillableContainerFromFile(containerLocation);
            refillingContainersList.add(refillableContainer);
        }
        return refillingContainersList;
    }

    @Override
    public boolean updateContainerTime(ContainerLocation containerLocation, int time) {
        try {
            String blockPositionAndWorldUUID = containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID();
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "time"}).setValue((Object)time);
            this.containersLoader.save(this.containersNode);
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean changeContainerName(ContainerLocation containerLocation, String containerName) {
        try {
            String blockPositionAndWorldUUID = containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID();
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "name"}).setValue((Object)containerName);
            this.containersLoader.save(this.containersNode);
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Kit> getKits() {
        try {
            List kits = this.kitsNode.getNode(new Object[]{"kits"}).getList((TypeToken)new TypeToken<Kit>(){});
            return kits;
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return new ArrayList<Kit>();
        }
    }

    @Override
    public boolean createKit(Kit kit) {
        try {
            ArrayList<Kit> kits = new ArrayList<Kit>(this.kitsNode.getNode(new Object[]{"kits"}).getList((TypeToken)new TypeToken<Kit>(){}));
            kits.add(kit);
            this.kitsNode.getNode(new Object[]{"kits"}).setValue((TypeToken)new TypeToken<List<Kit>>(){}, kits);
            this.kitsLoader.save(this.kitsNode);
            return true;
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeKit(String kitName) {
        try {
            ArrayList<Kit> kits = new ArrayList<Kit>(this.kitsNode.getNode(new Object[]{"kits"}).getList((TypeToken)new TypeToken<Kit>(){}));
            kits.removeIf(x -> x.getName().equals(kitName));
            this.kitsNode.getNode(new Object[]{"kits"}).setValue((TypeToken)new TypeToken<List<Kit>>(){}, kits);
            this.kitsLoader.save(this.kitsNode);
            Set blockPositionsAndWorldUUIDs = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers"}).getChildrenMap().keySet();
            for (Object blockPositionAndWorldUUID : blockPositionsAndWorldUUIDs) {
                if (!(blockPositionAndWorldUUID instanceof String)) continue;
                String blockPositionAndWorldUUIDString = String.valueOf(blockPositionAndWorldUUID);
                Object kitValue = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUIDString, "kit"}).getValue();
                if (kitValue == null || !String.valueOf(kitValue).equals(kitName)) continue;
                this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUIDString, "kit"}).setValue((Object)"");
            }
            return true;
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean assignKit(ContainerLocation containerLocation, String kitName) {
        try {
            String blockPositionAndWorldUUID = containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID();
            this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "kit"}).setValue((Object)kitName);
            this.containersLoader.save(this.containersNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Runnable checkFileUpdate() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    for (WatchEvent<?> event : JSONStorage.this._key.pollEvents()) {
                        Path changedFilePath = (Path)event.context();
                        if (!changedFilePath.toString().contains("containers.json")) continue;
                        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Detected changes in containers.json file. Reloading!"}));
                        JSONStorage.this.containersNode = JSONStorage.this.containersLoader.load();
                    }
                    JSONStorage.this._key.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private RefillableContainer getRefillableContainerFromFile(ContainerLocation containerLocation) {
        try {
            String blockPositionAndWorldUUID = containerLocation.getBlockPosition().toString() + "|" + containerLocation.getWorldUUID().toString();
            Object containersName = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "name"}).getValue();
            String name = null;
            if (containersName != null) {
                name = (String)containersName;
            }
            BlockType containerBlockType = (BlockType)this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "container-block-type"}).getValue(TypeToken.of(BlockType.class));
            String kitName = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "kit"}).getString("");
            ArrayList<RefillableItem> chestItems = (ArrayList<RefillableItem>)this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "items"}).getValue((TypeToken)new TypeToken<List<RefillableItem>>(){});
            int time = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "time"}).getInt();
            boolean isOneItemAtTime = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "one-item-at-time"}).getBoolean();
            boolean shouldReplaceExistingItems = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "replace-existing-items"}).getBoolean();
            boolean hiddenIfNoItems = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "hidden-if-no-items"}).getBoolean();
            BlockType hidingBlockType = (BlockType)this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "hiding-block"}).getValue(TypeToken.of(BlockType.class));
            String requiredPermission = this.containersNode.getNode(new Object[]{"chestrefill", "refillable-containers", blockPositionAndWorldUUID, "required-permission"}).getString("");
            if (chestItems == null) {
                chestItems = new ArrayList<RefillableItem>();
            }
            return new RefillableContainer(name, containerLocation, containerBlockType, chestItems, time, isOneItemAtTime, shouldReplaceExistingItems, hiddenIfNoItems, hidingBlockType, kitName, requiredPermission);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<RefillableItem> getKitItems(String kitName) {
        try {
            List kits = this.kitsNode.getNode(new Object[]{"kits"}).getList((TypeToken)new TypeToken<Kit>(){});
            for (Kit kit : kits) {
                if (!kit.getName().equals(kitName)) continue;
                return kit.getItems();
            }
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        return new ArrayList<RefillableItem>();
    }
}

