/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.command.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser.StandardParser;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.User;

public class SourceParser
extends StandardParser<CommandSource> {
    public static final SourceParser PARSER = new SourceParser((ImmutableMap<String, String>)ImmutableMap.of());
    private static final ImmutableList<String> MODIFIERS = ImmutableList.of((Object)"#me", (Object)"#self", (Object)"#console", (Object)"#server");

    public SourceParser(ImmutableMap<String, String> messages) {
        super(messages);
    }

    @Override
    public CommandSource parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        if (arg.startsWith("#")) {
            switch (arg.toLowerCase()) {
                case "#me": 
                case "#self": {
                    return src;
                }
                case "#console": 
                case "#server": {
                    return Sponge.getServer().getConsole();
                }
            }
            throw args.createError(this.getMessage("unknown-modifier", "No known modifier with the name <arg>.", "arg", arg));
        }
        return (CommandSource)Sponge.getServer().getPlayer(arg).orElseThrow(() -> args.createError(this.getMessage("no-player", "No player found with name <arg>.", "arg", arg)));
    }

    @Override
    public ImmutableList<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        return SourceParser.complete(args, Stream.concat(MODIFIERS.stream(), Sponge.getServer().getOnlinePlayers().stream().map(User::getName)));
    }
}

