/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions;

import com.google.common.collect.Iterables;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;

@ConfigSerializable
public class RentableRegionsConfig {
    @Setting(value="refresh-rate", comment="The interval (in seconds) to refresh the time remaining on rental signs")
    public long refreshRate = 1L;
    @Setting(value="currency-name", comment="The name of the currency to use when charging players. Use '' to ue the default currency")
    public String currencyName = "";

    public Currency getCurrency() {
        if (this.currencyName.isEmpty()) {
            return ((EconomyService)Sponge.getServiceManager().provideUnchecked(EconomyService.class)).getDefaultCurrency();
        }
        Currency currency = (Currency)Iterables.find((Iterable)((EconomyService)Sponge.getServiceManager().provideUnchecked(EconomyService.class)).getCurrencies(), c -> c.getName().equalsIgnoreCase(this.currencyName));
        if (currency == null) {
            throw new IllegalStateException("No currency with name: " + this.currencyName);
        }
        return currency;
    }
}

