/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.utils.RegionUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.data.LocationData;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class SignListeners {
    @Listener
    public void onChangeSign(ChangeSignEvent event, @First Player player) {
        BigDecimal price;
        Duration duration;
        List lines = (List)event.getText().lines().get();
        if (!((Text)lines.get(0)).toPlain().equals("[Region]")) {
            return;
        }
        if (!player.hasPermission("rentableregions.sign")) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to create a rental sign!"}));
            return;
        }
        String regionName = ((Text)lines.get(1)).toPlain();
        Region region = RegionUtils.load((String)regionName);
        if (region == null) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, String.format("Region '%s' does not exist!", regionName)}));
            return;
        }
        if (!(region instanceof LocalRegion)) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, String.format("Region '%s' is not a local region!", regionName)}));
            return;
        }
        lines.set(0, ((Text)lines.get(0)).toBuilder().color(TextColors.DARK_PURPLE).build());
        event.getText().setElements(lines);
        if (RentableRegions.getRegionsData().getRegion(regionName).isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Creating new sign for existing region rental!"}));
            RentableRegions.addDuplicateSign(regionName, new LocationData((Location<World>)event.getTargetTile().getLocation()));
            return;
        }
        String time = ((Text)lines.get(2)).toPlain();
        try {
            duration = RentableRegions.parseTime(time);
        }
        catch (Exception e) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Invalid rental time: " + e.getMessage()}));
            return;
        }
        try {
            price = new BigDecimal(((Text)lines.get(3)).toPlain());
        }
        catch (NumberFormatException e) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Price " + ((Text)lines.get(3)).toPlain() + " is not a number!"}));
            return;
        }
        RentedRegion rentedRegion = new RentedRegion(regionName, duration, price, new LocationData((Location<World>)event.getTargetTile().getLocation()));
        RentableRegions.addRentedRegion(regionName, rentedRegion);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully created rental sign!"}));
    }

    @Listener
    public void onBreak(ChangeBlockEvent.Break event, @First Player player) {
        for (Transaction transaction : event.getTransactions()) {
            Optional<RentedRegion> region;
            if (!((BlockSnapshot)transaction.getOriginal()).getState().getType().equals(BlockTypes.WALL_SIGN) && !((BlockSnapshot)transaction.getOriginal()).getState().getType().equals(BlockTypes.STANDING_SIGN) || !(region = RentableRegions.getRegionsData().getForLocation((Location<World>)((Location)((BlockSnapshot)transaction.getOriginal()).getLocation().get()))).isPresent()) continue;
            if (!player.hasPermission("rentableregions.sign")) {
                transaction.setValid(false);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to break region signs!"}));
                continue;
            }
            region.get().removeSign((Location<World>)((Location)((BlockSnapshot)transaction.getOriginal()).getLocation().get()));
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Removed rental sign!"}));
        }
    }

    @Listener
    public void onRightClickSign(InteractBlockEvent.Secondary.MainHand event, @First Player player) {
        if (!event.getTargetBlock().getLocation().isPresent()) {
            return;
        }
        Optional<RentedRegion> regionOpt = RentableRegions.getRegionsData().getForLocation((Location<World>)((Location)event.getTargetBlock().getLocation().get()));
        if (!regionOpt.isPresent()) {
            return;
        }
        RentedRegion region = regionOpt.get();
        if (region.isRented()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "This region is currently rented!"}));
            return;
        }
        if (!player.hasPermission("rentableregions.command.rent")) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to rent regins!"}));
            return;
        }
        String rawCommand = "/rrg rent " + region.name;
        LiteralText command = Text.builder((String)rawCommand).onClick((ClickAction)TextActions.runCommand((String)rawCommand)).color(TextColors.LIGHT_PURPLE).style(new TextStyle[]{TextStyles.UNDERLINE}).build();
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Run "}).concat((Text)command).concat((Text)Text.of((String)" to rent this region!")));
    }
}

