/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;

public class ListCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"List the reigons you are currently renting")).permission("rentableregions.command.list").executor((CommandExecutor)new ListCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to run this command!"}));
            return CommandResult.empty();
        }
        PaginationList.Builder builder = PaginationList.builder().title((Text)Text.of((String)"Rented regions"));
        builder.contents((Iterable)RentableRegions.getRegionsFor(((Player)src).getUniqueId()).stream().map(r -> Text.of((Object[])new Object[]{TextColors.GREEN, r.name, TextColors.WHITE, " - Remaining: ", TextColors.YELLOW, RentableRegions.formatTime(r.getRemainingTime())})).collect(Collectors.toList()));
        builder.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

