/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class RentCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Rent the specified region")).permission("rentableregions.command.rent").arguments(GenericArguments.string((Text)Text.of((String)"region"))).executor((CommandExecutor)new RentCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to run this command!"}));
            return CommandResult.empty();
        }
        String regionName = (String)args.getOne((Text)Text.of((String)"region")).get();
        RentedRegion rentedRegion = RentableRegions.getRegionsData().getRegion(regionName).orElseThrow(() -> new CommandException((Text)Text.of((String)("Unknown region with name " + regionName))));
        if (rentedRegion.isRented()) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "This region is currently being rented!"}));
            return CommandResult.empty();
        }
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You are about to rent region " + regionName + " for " + RentableRegions.formatTime(rentedRegion.getRemainingTime()) + " for a price of $" + rentedRegion.price + ". To confirm, run "}).concat(RentableRegionsCommand.getConfirmText()));
        RentableRegions.onConfirm((Player)src, player -> {
            RentedRegion region = RentableRegions.getRegionsData().getRegion(regionName).orElseThrow(() -> new RuntimeException("Unknown region with name " + regionName));
            if (RentableRegions.startRenting(player, region)) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "You successfully rented region " + regionName}));
            }
        });
        return CommandResult.success();
    }
}

