/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class TimeCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Shows the time remaining on a rented region")).arguments(RentableRegionsCommand.getRegionElement()).permission("rentableregions.command.time").executor((CommandExecutor)new TimeCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        RentedRegion region = (RentedRegion)args.getOne((Text)Text.of((String)"region")).get();
        if (!region.isRented()) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Region " + region.name + " is not currently rented!"}));
        } else {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Time remaining on region " + region.name + ": " + RentableRegions.formatTime(region.getRemainingTime())}));
        }
        return CommandResult.success();
    }
}

