/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class UnrentCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Stops renting a region, giving you a partial refund")).permission("rentableregions.command.unrent").arguments(RentableRegionsCommand.getOwnRegionElement()).executor((CommandExecutor)new UnrentCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to run this command!"}));
            return CommandResult.empty();
        }
        RentedRegion region = (RentedRegion)args.getOne((Text)Text.of((String)"region")).get();
        if (!region.isRented()) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "This region is not currently being rented"}));
            return CommandResult.empty();
        }
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You are going to stop renting region " + region.name + ". To confirm, run "}).concat(RentableRegionsCommand.getConfirmText()));
        String regionName = region.name;
        RentableRegions.onConfirm((Player)src, p -> {
            Optional<RentedRegion> rentedRegion = RentableRegions.getRegionsData().getRegion(regionName);
            if (!rentedRegion.isPresent()) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Region " + regionName + " no longer exists!"}));
                return;
            }
            if (!rentedRegion.get().isRented() || !rentedRegion.get().owner.equals(((Player)src).getUniqueId())) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Cannot unrent - you are not currently renting region " + regionName}));
                return;
            }
            RentableRegions.stopRenting(((Player)src).getUniqueId(), rentedRegion.get(), true);
        });
        return CommandResult.success();
    }
}

