/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.data;

import com.flowpowered.math.vector.Vector3i;
import java.util.Objects;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@ConfigSerializable
public class LocationData {
    @Setting(value="world-uuid")
    public UUID worldUUID;
    @Setting(value="pos")
    public Vector3i pos;

    public LocationData() {
    }

    public Location<World> getLocation() {
        return new Location((Extent)Sponge.getServer().getWorld(this.worldUUID).orElseThrow(() -> new IllegalStateException("No world found with UUID " + this.worldUUID)), this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationData that = (LocationData)o;
        return Objects.equals(this.worldUUID, that.worldUUID) && Objects.equals(this.pos, that.pos);
    }

    public int hashCode() {
        return Objects.hash(this.worldUUID, this.pos);
    }

    public LocationData(Location<World> location) {
        this.worldUUID = ((World)location.getExtent()).getUniqueId();
        this.pos = location.getBlockPosition();
    }
}

