/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.matching.Matching;

public class MatchingController {
    private final Int2ObjectMap<Matching> matchingControlMap = new Int2ObjectOpenHashMap();
    private final Collection<Matching> values = this.matchingControlMap.values();
    private final IInventory inventory;

    public MatchingController(@Nonnull IInventory inventory) {
        this.inventory = inventory;
    }

    public MatchingController(@Nonnull IInventory inventory, Matching ... matchings) {
        this(inventory);
        for (Matching matching : matchings) {
            this.add(matching);
        }
    }

    public MatchingController(@Nonnull IInventory inventory, @Nonnull List<Matching> matchingList) {
        this(inventory);
        matchingList.forEach(this::add);
    }

    public MatchingController(@Nonnull IInventory inventory, @Nonnull Int2ObjectMap<Matching> matchingMap) {
        this(inventory);
        this.matchingControlMap.putAll(matchingMap);
    }

    public void add(@Nonnull Matching matching) {
        this.matchingControlMap.put(matching.hashCode(), (Object)matching);
    }

    public Collection<Matching> getInstances() {
        return this.values;
    }

    public Matching getMatching(int number) {
        return (Matching)this.matchingControlMap.get(number);
    }

    @Nonnull
    public List<Matching> compareContents(@Nonnull MatchingController otherMatchingController) {
        ArrayList<Matching> differences = new ArrayList<Matching>();
        for (Matching matching : this.values) {
            Matching otherMatching;
            if (matching.equals(otherMatching = (Matching)otherMatchingController.matchingControlMap.get(matching.hashCode()))) continue;
            differences.add(matching);
        }
        return differences;
    }

    public void syncMatching(@Nonnull NBTTagCompound nbtTagCompound) {
        this.matchingControlMap.values().forEach(matchingControl -> matchingControl.readFromNBT(nbtTagCompound));
        this.inventory.func_70296_d();
    }
}

