/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.matching.Matching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.AnyDamageMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;
import wanion.lib.common.matching.matcher.NbtMatcher;
import wanion.lib.common.matching.matcher.OreDictMatcher;

public class ItemStackMatcher
extends AbstractMatcher {
    public ItemStackMatcher(@Nonnull Matching matching) {
        super(matching);
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.ITEM_STACK;
    }

    @Override
    @Nonnull
    public AbstractMatcher validate() {
        return this;
    }

    @Override
    @Nonnull
    public AbstractMatcher next() {
        ItemStack itemStack = this.getStack();
        if (itemStack.func_77981_g() || itemStack.func_77984_f()) {
            return new AnyDamageMatcher(this.matching);
        }
        if (this.matching.shouldUseNbt() && itemStack.func_77942_o()) {
            return new NbtMatcher(this.matching);
        }
        if (OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
            return new OreDictMatcher(this.matching);
        }
        return this;
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        return this.getStack().func_77969_a(otherItemStack);
    }

    @Override
    @Nonnull
    public String ctFormat() {
        ItemStack itemStack = this.getStack();
        StringBuilder formatBuilder = new StringBuilder().append('<');
        formatBuilder.append(itemStack.func_77973_b().getRegistryName());
        if (itemStack.func_77952_i() > 0) {
            formatBuilder.append(':').append(itemStack.func_77952_i());
        }
        formatBuilder.append('>');
        if (itemStack.func_190916_E() > 1) {
            formatBuilder.append(" * ").append(itemStack.func_190916_E());
        }
        return formatBuilder.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ItemStackMatcher;
    }
}

