/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import com.google.common.base.Strings;
import ic2.api.classic.item.IItemReactorPlanStorage;
import ic2.api.classic.network.ICustomNetworkClientTileEventListener;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.machine.med.container.ContainerReactorPlanner;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.block.machine.med.logic.ReactorPlannerInv;
import ic2.core.block.machine.med.logic.TickingReactorLogic;
import ic2.core.block.machine.med.logic.TickingSteamReactorLogic;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.block.machine.med.logic.encoder.EncoderRegistry;
import ic2.core.block.machine.med.logic.encoder.IEncoder;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.network.packets.server.ReactorPlannerEncoderPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.obj.IClickable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorPlanner
extends TileEntityElecMachine
implements IHasGui,
INetworkClientTileEventListener,
ITickable,
ICustomNetworkClientTileEventListener,
IClickable {
    public ReactorPlannerInv components = new ReactorPlannerInv(this);
    @NetworkField(index=7)
    public UserSettings settings = new UserSettings();
    @NetworkField(index=8)
    public ReactorBackup backup = new ReactorBackup();
    @NetworkField(index=9)
    public ReactorLogicBase reactor = new TickingReactorLogic(this);
    @NetworkField(index=10)
    public ReactorLogicBase.IReactorPrediction reactorPrediction = new TickingReactorLogic.ReactorPrediction();
    @NetworkField(index=11)
    public ReactorLogicBase steamReactor = new TickingSteamReactorLogic(this);
    @NetworkField(index=12)
    public ReactorLogicBase.IReactorPrediction steamReactorPrediction = new TickingSteamReactorLogic.SteamReactorPrediction();
    @NetworkField(index=13)
    public int selectedSlot = 0;
    @NetworkField(index=14)
    public int stackSize = 1;
    @NetworkField(index=15)
    public int selectedView = 2;
    @NetworkField(index=16)
    public String setupName = "";
    @NetworkField(index=17)
    public int reactorSize = 6;
    @NetworkField(index=18)
    public boolean isSteamReactor = false;

    public TileEntityReactorPlanner() {
        super(0, 128);
        this.maxEnergy = 100000;
        this.addGuiFields("isSteamReactor", "reactorSize", "setupName", "selectedView", "stackSize", "selectedSlot", "steamReactorPrediction", "steamReactor", "reactorPrediction", "reactor", "backup", "settings", "components");
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    public ReactorLogicBase getReactorLogic() {
        return this.isSteamReactor ? this.steamReactor : this.reactor;
    }

    public ReactorLogicBase.IReactorPrediction getPrediction() {
        return this.isSteamReactor ? this.steamReactorPrediction : this.reactorPrediction;
    }

    public UserSettings getUserSettings() {
        return this.settings;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiFieldSynced(String field) {
        if (field.equals("reactorSize")) {
            this.onSizeUpdate(Minecraft.func_71410_x().field_71439_g.field_71071_by);
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerReactorPlanner(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.reactorPlanner;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof IItemReactorPlanStorage) {
            if (side == Side.CLIENT) {
                return false;
            }
            IItemReactorPlanStorage storage = (IItemReactorPlanStorage)stack.func_77973_b();
            if (!storage.isPlanStorage(stack)) {
                return false;
            }
            if (player.func_70093_af()) {
                IEncoder encoder = EncoderRegistry.instance.getDefaultEncoder();
                String setup = encoder.createEncodedData(this);
                if (!Strings.isNullOrEmpty((String)setup)) {
                    if (storage.setSetup(stack, setup)) {
                        if (!Strings.isNullOrEmpty((String)this.setupName)) {
                            storage.setPlanName(stack, this.setupName);
                        }
                        IC2.platform.messagePlayer(player, Ic2GuiLang.setupExported);
                        return true;
                    }
                    IC2.platform.messagePlayer(player, Ic2GuiLang.setupExportFailed);
                } else {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.setupExporterFailed);
                }
                return true;
            }
            if (storage.hasSetup(stack)) {
                Tuple<String, NBTTagCompound> data = EncoderRegistry.instance.createDecodedMessage(storage.getSetup(stack));
                if (data != null) {
                    IEncoder encoder = EncoderRegistry.instance.getEncoderFromID((String)data.func_76341_a());
                    int oldSize = this.reactorSize;
                    boolean steam = this.isSteamReactor;
                    String oldName = this.setupName;
                    NBTTagCompound backup = new NBTTagCompound();
                    NBTTagCompound settingBackup = new NBTTagCompound();
                    this.getReactorLogic().writeToNBT(backup);
                    this.getUserSettings().writeToNBT(settingBackup);
                    encoder.processData((NBTTagCompound)data.func_76340_b(), this);
                    boolean failed = false;
                    if (!this.getReactorLogic().isValid()) {
                        failed = true;
                        this.getReactorLogic().clear();
                        this.isSteamReactor = steam;
                        this.reactorSize = oldSize;
                        this.setupName = oldName;
                        this.getReactorLogic().readFromNBT(backup);
                        this.getUserSettings().readFromNBT(settingBackup);
                    }
                    ReactorLogicBase.IReactorPrediction pred = this.getReactorLogic().createPrediction();
                    NBTTagCompound nbt = new NBTTagCompound();
                    pred.writeToNBT(nbt);
                    this.getPrediction().readFromNBT(nbt.func_74737_b());
                    this.getNetwork().updateTileGuiField(this, "isSteamReactor");
                    this.getNetwork().updateTileGuiField(this, "reactorSize");
                    this.getNetwork().updateTileGuiField(this, "setupName");
                    this.updateReactor();
                    this.updatePrediction();
                    this.onSizeUpdate(player.field_71071_by);
                    IC2.platform.messagePlayer(player, failed ? Ic2GuiLang.setupImportingFailed : Ic2GuiLang.setupImported);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.components.create();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (!this.getActive()) {
            return;
        }
        if (!this.hasEnergy(100)) {
            return;
        }
        this.useEnergy(100);
        ReactorLogicBase base = this.getReactorLogic();
        if (base.isFinished()) {
            this.setActive(false);
            return;
        }
        UserSettings setting = this.getUserSettings();
        if (base.isValid() && !base.didReactorBreak()) {
            for (int i = 0; i < setting.ticksPerTick && !base.isFinished() && !base.didReactorBreak(); ++i) {
                base.onTick();
                if (!base.isFinished()) continue;
                base.onFinished();
                this.setActive(false);
            }
            this.updateReactor();
        } else {
            this.setActive(false);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.components.readFromNBT(nbt.func_74775_l("Components"));
        this.settings.readFromNBT(nbt.func_74775_l("Settings"));
        this.isSteamReactor = nbt.func_74767_n("steam");
        this.reactorSize = nbt.func_74762_e("ReactorSize");
        this.selectedSlot = nbt.func_74762_e("SelectedSlot");
        this.getReactorLogic().readFromNBT(nbt.func_74775_l("Logic"));
        this.getPrediction().readFromNBT(nbt.func_74775_l("Prediction"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.components.writeToNBT(this.getTag(nbt, "Components"));
        this.settings.writeToNBT(this.getTag(nbt, "Settings"));
        this.getReactorLogic().writeToNBT(this.getTag(nbt, "Logic"));
        this.getPrediction().writeToNBT(this.getTag(nbt, "Prediction"));
        nbt.func_74757_a("steam", this.isSteamReactor);
        nbt.func_74768_a("ReactorSize", this.reactorSize);
        nbt.func_74768_a("SelectedSlot", this.selectedSlot);
        return nbt;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        ByteShifter shifter = new ByteShifter(event);
        int id = shifter.readInt(3);
        if (id == 0) {
            int subID = shifter.readInt(2);
            if (subID == 0) {
                this.components.applyOffset(value);
                this.getNetwork().updateTileGuiField(this, "components");
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.updateContainer(player);
            } else if (subID == 1) {
                this.components.setNextFilter();
                this.selectedSlot = 0;
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.getNetwork().updateTileGuiField(this, "components");
                this.updateContainer(player);
            } else if (subID == 2) {
                this.reactorSize += value;
                if (this.reactorSize < 0) {
                    this.reactorSize = 0;
                }
                if (this.reactorSize > 6) {
                    this.reactorSize = 6;
                }
                this.getNetwork().updateTileGuiField(this, "reactorSize");
                this.onSizeUpdate(player.field_71071_by);
            }
        } else if (id == 1) {
            ReactorLogicBase base;
            int subID = shifter.readInt(3);
            if (subID == 0) {
                this.stackSize += value;
                if (this.stackSize < 1) {
                    this.stackSize = 1;
                }
                if (this.stackSize > 64) {
                    this.stackSize = 64;
                }
                this.getNetwork().updateTileGuiField(this, "stackSize");
            } else if (subID == 1) {
                this.setActive(value == 0);
            } else if (subID == 2) {
                base = this.getReactorLogic();
                if (value == 0) {
                    if (!base.isValid()) {
                        base.validate();
                        NBTTagCompound data = new NBTTagCompound();
                        ReactorLogicBase.IReactorPrediction pred = base.createPrediction();
                        pred.writeToNBT(data);
                        this.getPrediction().readFromNBT(data.func_74737_b());
                        this.updateReactor();
                        this.updatePrediction();
                    }
                } else if (base.isValid()) {
                    base.reset();
                    this.getPrediction().clear();
                    this.updateReactor();
                    this.updatePrediction();
                }
            } else if (subID == 3) {
                base = this.getReactorLogic();
                if (value == 0) {
                    if (base.isValid()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        base.createBackup().writeToNBT(nbt);
                        this.backup.readFromNBT(nbt.func_74737_b());
                        this.getNetwork().updateTileGuiField(this, "backup");
                        this.getNetwork().updateTileGuiField(this, "settings");
                        this.updateReactor();
                        this.updatePrediction();
                    }
                } else if (this.backup.hasBackup) {
                    base.clear();
                    this.getPrediction().clear();
                    this.isSteamReactor = this.backup.isSteam;
                    this.reactorSize = this.backup.reactorSize;
                    this.getNetwork().updateTileEntityField(this, "reactorSize");
                    base = this.getReactorLogic();
                    base.restoreFromBackup(this.backup);
                    this.updateReactor();
                    this.updatePrediction();
                    this.getNetwork().updateTileGuiField(this, "settings");
                    this.setupName = "";
                    this.getNetwork().updateTileGuiField(this, "setupName");
                    this.onSizeUpdate(player.field_71071_by);
                }
            }
            if (subID == 4) {
                if (value == 0) {
                    this.getReactorLogic().clear();
                    this.getPrediction().clear();
                    this.updateReactor();
                    this.updatePrediction();
                    this.updateContainer(player);
                    this.setupName = "";
                    this.getNetwork().updateTileGuiField(this, "setupName");
                } else if (value == 1) {
                    this.backup = new ReactorBackup();
                    this.getNetwork().updateTileGuiField(this, "backup");
                }
            } else if (subID == 5) {
                base = this.getReactorLogic();
                base.producing = !base.producing;
                this.updateReactor();
            }
        } else if (id == 2) {
            int subID = shifter.readInt(2);
            if (subID == 0) {
                UserSettings user = this.getUserSettings();
                ReactorLogicBase base = this.getReactorLogic();
                int maxHeat = base.maxHeat - 100;
                user.startingHeat += value;
                if (user.startingHeat > maxHeat) {
                    user.startingHeat = maxHeat;
                }
                if (user.startingHeat < 0) {
                    user.startingHeat = 0;
                }
                if (!this.getActive()) {
                    base.setHeat(user.startingHeat);
                    this.getNetwork().updateTileGuiField(this, "settings");
                }
                this.updateReactor();
            } else if (subID == 1) {
                UserSettings user = this.getUserSettings();
                user.maxTicks += value;
                if (user.maxTicks < 0) {
                    user.maxTicks = 0;
                }
                if (user.maxTicks > 99999999) {
                    user.maxTicks = 99999999;
                }
                this.getNetwork().updateTileGuiField(this, "settings");
            } else if (subID == 2) {
                int max = IC2.config.getInt("reactorPlannerMaxTicks");
                UserSettings user = this.getUserSettings();
                user.ticksPerTick += value;
                if (user.ticksPerTick < 1) {
                    user.ticksPerTick = 1;
                }
                if (user.ticksPerTick > max) {
                    user.ticksPerTick = max;
                }
                this.getNetwork().updateTileGuiField(this, "settings");
            }
        } else if (id == 3) {
            int subID = shifter.readInt(1);
            if (subID == 0) {
                this.selectedView = value;
                this.getNetwork().updateTileGuiField(this, "selectedView");
            } else if (subID == 1) {
                this.clearCurrentReactor();
                this.isSteamReactor = value == 1;
                this.selectedSlot = 0;
                this.components.offset = 0;
                this.components.create();
                this.getNetwork().updateTileGuiField(this, "isSteamReactor");
                this.getNetwork().updateTileGuiField(this, "components");
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.updateContainer(player);
            }
        }
    }

    @Override
    public void onClientNetworkEvent(EntityPlayer player, INetworkFieldData packet) {
        if (packet instanceof PayloadFieldPacket) {
            int number;
            PayloadFieldPacket payload = (PayloadFieldPacket)packet;
            int amount = payload.getSize(0);
            if (amount == 2) {
                String key = payload.getString(0);
                NBTTagCompound data = this.getNBTFromString(payload.getString(1));
                if (data.func_82582_d()) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.setupImportingFailed);
                    return;
                }
                IEncoder encoder = EncoderRegistry.instance.getEncoderFromID(key);
                if (encoder == null) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.setupImportFailedNoDecoder);
                    return;
                }
                int oldSize = this.reactorSize;
                boolean steam = this.isSteamReactor;
                String oldName = this.setupName;
                NBTTagCompound backup = new NBTTagCompound();
                NBTTagCompound settingBackup = new NBTTagCompound();
                this.getReactorLogic().writeToNBT(backup);
                this.getUserSettings().writeToNBT(settingBackup);
                encoder.processData(data, this);
                boolean failed = false;
                if (!this.getReactorLogic().isValid()) {
                    failed = true;
                    this.getReactorLogic().clear();
                    this.isSteamReactor = steam;
                    this.reactorSize = oldSize;
                    this.setupName = oldName;
                    this.getReactorLogic().readFromNBT(backup);
                    this.getUserSettings().readFromNBT(settingBackup);
                }
                ReactorLogicBase.IReactorPrediction pred = this.getReactorLogic().createPrediction();
                NBTTagCompound nbt = new NBTTagCompound();
                pred.writeToNBT(nbt);
                this.getPrediction().readFromNBT(nbt.func_74737_b());
                this.getNetwork().updateTileGuiField(this, "isSteamReactor");
                this.getNetwork().updateTileGuiField(this, "reactorSize");
                this.updateReactor();
                this.updatePrediction();
                this.onSizeUpdate(player.field_71071_by);
                IC2.platform.messagePlayer(player, failed ? Ic2GuiLang.setupImportingFailed : Ic2GuiLang.setupImported);
            } else if (amount == 1 && (number = payload.getSize(1)) == 1) {
                int type = payload.getNumber(0);
                if (type == 0) {
                    IEncoder encoder = EncoderRegistry.instance.getEncoderFromID(payload.getString(0));
                    if (encoder == null) {
                        IC2.platform.messagePlayer(player, Ic2GuiLang.setupExportFailedNoEncoder);
                        return;
                    }
                    String encoded = encoder.createEncodedData(this);
                    if (Strings.isNullOrEmpty((String)encoded)) {
                        IC2.platform.messagePlayer(player, Ic2GuiLang.setupExporterFailed);
                        return;
                    }
                    this.getNetwork().sendCustomPacket(player, new ReactorPlannerEncoderPacket(encoded));
                } else if (type == 1) {
                    this.setupName = payload.getString(0);
                    this.getNetwork().updateTileGuiField(this, "setupName");
                }
            }
        }
    }

    private NBTTagCompound getNBTFromString(String key) {
        try {
            return JsonToNBT.func_180713_a((String)key);
        }
        catch (Exception exception) {
            return new NBTTagCompound();
        }
    }

    private void updateContainer(EntityPlayer player) {
        ContainerReactorPlanner cont = this.getContainer(player);
        if (cont != null) {
            cont.func_75142_b();
        }
    }

    private ContainerReactorPlanner getContainer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        Container cont = player.field_71070_bA;
        if (cont instanceof ContainerReactorPlanner) {
            return (ContainerReactorPlanner)cont;
        }
        return null;
    }

    private void onSizeUpdate(InventoryPlayer player) {
        this.getReactorLogic().onSizeUpdate();
        ContainerReactorPlanner cont = this.getContainer(player.field_70458_d);
        if (cont != null) {
            cont.reset(player);
            cont.func_75142_b();
        }
    }

    public void clearCurrentReactor() {
        this.getReactorLogic().clear();
        this.getPrediction().clear();
        this.updateReactor();
        this.updatePrediction();
        this.setupName = "";
        this.getNetwork().updateTileGuiField(this, "setupName");
    }

    public void updateReactor() {
        this.getNetwork().updateTileGuiField(this, this.isSteamReactor ? "steamReactor" : "reactor");
    }

    public void updatePrediction() {
        this.getNetwork().updateTileGuiField(this, this.isSteamReactor ? "steamReactorPrediction" : "reactorPrediction");
    }

    public static class ReactorBackup
    implements INetworkFieldData {
        public NonNullList<ItemStack> items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        public int customTicks;
        public int customHeat;
        public int reactorSize;
        public boolean hasBackup = false;
        public boolean isSteam;

        public void readFromNBT(NBTTagCompound nbt) {
            this.customTicks = nbt.func_74762_e("CustomTicks");
            this.customHeat = nbt.func_74762_e("CustomHeat");
            this.reactorSize = nbt.func_74762_e("Size");
            this.hasBackup = nbt.func_74767_n("HasBackup");
            this.isSteam = nbt.func_74767_n("isSteam");
            this.items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
            NBTTagList list = nbt.func_150295_c("Setup", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                this.items.set(data.func_74762_e("Slot"), (Object)new ItemStack(data));
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("CustomTicks", this.customTicks);
            nbt.func_74768_a("CustomHeat", this.customHeat);
            nbt.func_74768_a("Size", this.reactorSize);
            nbt.func_74757_a("HasBackup", this.hasBackup);
            nbt.func_74757_a("isSteam", this.isSteam);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < 54; ++i) {
                NBTTagCompound data = new NBTTagCompound();
                ((ItemStack)this.items.get(i)).func_77955_b(data);
                data.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)data);
            }
            nbt.func_74782_a("Setup", (NBTBase)list);
        }

        @Override
        public void read(IInputBuffer buffer) {
            this.hasBackup = buffer.readBoolean();
            this.reactorSize = buffer.readByte();
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeBoolean(this.hasBackup);
            buffer.writeByte((byte)this.reactorSize);
        }
    }

    public static class UserSettings
    implements INetworkFieldData {
        public int maxTicks = 0;
        public int startingHeat = 0;
        public int ticksPerTick = 1;

        @Override
        public void read(IInputBuffer buffer) {
            this.maxTicks = buffer.readInt();
            this.startingHeat = buffer.readInt();
            this.ticksPerTick = buffer.readInt();
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeInt(this.maxTicks);
            buffer.writeInt(this.startingHeat);
            buffer.writeInt(this.ticksPerTick);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.maxTicks = nbt.func_74762_e("Max");
            this.startingHeat = nbt.func_74762_e("StartingHeat");
            this.ticksPerTick = nbt.func_74762_e("Ticks");
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("Max", this.maxTicks);
            nbt.func_74768_a("StartingHeat", this.startingHeat);
            nbt.func_74768_a("Ticks", this.ticksPerTick);
        }
    }
}

