/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.inventory.base.IC2ItemInventory;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.item.inv.container.ContainerCropBreeder;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryCropBreeder
extends IC2ItemInventory {
    public CropList provided;
    public ResultList results;

    public InventoryCropBreeder(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        super(player, inv, item);
        this.provided.init();
        this.provided.updateSlots();
        this.results.updateSlots();
    }

    public void process() {
        ArrayList<CropCard> toBreed = new ArrayList<CropCard>(4);
        for (int i = 0; i < 4; ++i) {
            CropCard card;
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (!(stack.func_77973_b() instanceof ICropSeed) || (card = ((ICropSeed)stack.func_77973_b()).getCropFromStack(stack)) == null) continue;
            toBreed.add(card);
        }
        ArrayList<CropCard> resultList = new ArrayList<CropCard>(Crops.instance.getCrops());
        resultList.remove(Crops.weed);
        int[] ratios = new int[resultList.size()];
        int total = 0;
        for (int i = 0; i < resultList.size(); ++i) {
            CropCard card = (CropCard)resultList.get(i);
            for (int j = 0; j < toBreed.size(); ++j) {
                int chance = TileEntityCrop.calculateRatioFor(card, (CropCard)toBreed.get(j));
                int n = i;
                ratios[n] = ratios[n] + chance;
                total += chance;
            }
        }
        ArrayList iterator = new ArrayList();
        this.results.clear();
        for (int i = 0; i < resultList.size(); ++i) {
            if (ratios[i] <= 0) continue;
            float percent = (float)ratios[i] / (float)total * 100.0f;
            ItemStack stack = ItemCropSeed.generateItemStack((CropCard)resultList.get(i), 0, 0, 0, 1);
            StackUtil.addToolTip(stack, TextFormatting.GREEN + "" + Ic2InfoLang.cropEntryPoints.getLocalizedFormatted(ratios[i]));
            StackUtil.addToolTip(stack, TextFormatting.GOLD + "" + Ic2InfoLang.cropEntryChance.getLocalizedFormatted(Ic2Formatters.stackFormat.format(percent)) + "%");
            StackUtil.getOrCreateNbtData(stack).func_74768_a("Points", ratios[i]);
            ItemCropSeed.setVisible(stack);
            this.results.addResult(stack);
        }
        this.results.sort();
        this.results.updateSlots();
    }

    public void addBreed(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (int i = 0; i < 4; ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                this.inventory.set(i, (Object)stack.func_77946_l());
                return;
            }
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCropBreeder(this, this.getID());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.provided = new CropList();
        this.provided.readFromNBT(nbt);
        this.results = new ResultList();
        this.results.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.provided.writeToNBT(nbt);
        this.results.writeToNBT(nbt);
    }

    @Override
    protected String getInventoryTag() {
        return "BreedingItems";
    }

    public static class CropList
    implements IHasInventory {
        List<ItemStack> list = new ArrayList<ItemStack>();
        int offset = 0;
        NonNullList<ItemStack> array = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

        public void init() {
            for (CropCard card : Crops.instance.getCrops()) {
                if (card == Crops.weed) continue;
                ItemStack stack = ItemCropSeed.generateItemStack(card, 0, 0, 0, 1);
                ItemCropSeed.setVisible(stack);
                this.list.add(stack);
            }
            this.offset = MathHelper.func_76125_a((int)this.offset, (int)0, (int)(this.list.size() - 9));
        }

        public void updateSlots() {
            for (int i = 0; i < 9; ++i) {
                if (i + this.offset >= this.list.size()) {
                    this.array.set(i, (Object)ItemStack.field_190927_a);
                    continue;
                }
                this.array.set(i, (Object)this.list.get(i + this.offset));
            }
        }

        public void offset(int extra) {
            this.offset = MathHelper.func_76125_a((int)(this.offset + extra), (int)0, (int)(this.list.size() - 9));
            this.updateSlots();
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            this.array.set(slot, (Object)stack);
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.array.get(slot);
        }

        @Override
        public int getSlotCount() {
            return 9;
        }

        @Override
        public int getMaxStackSize(int slot) {
            return 1;
        }

        @Override
        public boolean canInsert(int slot, ItemStack stack) {
            return false;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.offset = nbt.func_74762_e("Offset");
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("Offset", this.offset);
        }
    }

    public static class ResultList
    implements IHasInventory {
        List<ItemStack> list = new ArrayList<ItemStack>();
        int offset = 0;
        NonNullList<ItemStack> array = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

        public void updateSlots() {
            for (int i = 0; i < 9; ++i) {
                if (i + this.offset >= this.list.size()) {
                    this.array.set(i, (Object)ItemStack.field_190927_a);
                    continue;
                }
                this.array.set(i, (Object)this.list.get(i + this.offset));
            }
        }

        public void offset(int extra) {
            this.offset = MathHelper.func_76125_a((int)(this.offset + extra), (int)0, (int)Math.max(0, this.list.size() - 9));
            this.updateSlots();
        }

        public void addResult(ItemStack stack) {
            this.list.add(stack);
        }

        public void sort() {
            this.list.sort(new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int secondPoints;
                    int firstPoints = this.getPoints(o1);
                    if (firstPoints > (secondPoints = this.getPoints(o2))) {
                        return -1;
                    }
                    if (secondPoints > firstPoints) {
                        return 1;
                    }
                    return 0;
                }

                public int getPoints(ItemStack stack) {
                    return StackUtil.getNbtData(stack).func_74762_e("Points");
                }
            });
        }

        public void clear() {
            this.list.clear();
            this.offset = 0;
            this.updateSlots();
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            this.array.set(slot, (Object)stack);
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.array.get(slot);
        }

        @Override
        public int getSlotCount() {
            return 9;
        }

        @Override
        public int getMaxStackSize(int slot) {
            return 1;
        }

        @Override
        public boolean canInsert(int slot, ItemStack stack) {
            return false;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagList nbtList = new NBTTagList();
            for (int i = 0; i < this.list.size(); ++i) {
                nbtList.func_74742_a((NBTBase)this.list.get(i).func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("ResultData", (NBTBase)nbtList);
            nbt.func_74768_a("ResultOffset", this.offset);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagList nbtList = nbt.func_150295_c("ResultData", 10);
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack result = new ItemStack(nbtList.func_150305_b(i));
                if (result.func_190926_b()) continue;
                this.list.add(result);
            }
            this.offset = MathHelper.func_76125_a((int)nbt.func_74762_e("ResultOffset"), (int)0, (int)Math.max(this.list.size() - 9, 0));
        }
    }
}

